/*
 * Decompiled with CFR 0.152.
 */
package test;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermFactory;
import aterm.pure.PureFactory;
import java.io.IOException;
import jjtraveler.TopDown;
import jjtraveler.VisitFailure;
import test.NodeCounter;

public class VisitorBenchmark {
    static int id = 0;
    static ATermFactory factory = new PureFactory();
    static AFun fun;

    public static final void main(String[] args) throws IOException, VisitFailure {
        try {
            int depth = 5;
            int fanout = 5;
            long beforeBuild = System.currentTimeMillis();
            fun = factory.makeAFun("f", fanout, false);
            ATerm term = VisitorBenchmark.buildTerm(depth, fanout);
            long beforeVisit = System.currentTimeMillis();
            NodeCounter nodeCounter = new NodeCounter();
            TopDown topDownNodeCounter = new TopDown(nodeCounter);
            try {
                topDownNodeCounter.visit(term);
                long end = System.currentTimeMillis();
                System.out.println("Term of depth " + depth + " with fanout " + fanout + " (" + nodeCounter.getCount() + " nodes)" + ": build=" + (beforeVisit - beforeBuild) + ", visit=" + (end - beforeVisit));
            }
            catch (VisitFailure e) {
                System.err.println("WARING: VisitFailure: " + e.getMessage());
            }
        }
        catch (NumberFormatException e) {
            System.err.println("usage: java VisitorBenchmark <depth> <fanout>");
        }
    }

    private static ATerm buildTerm(int depth, int fanout) {
        if (depth == 1) {
            return factory.makeInt(id++);
        }
        ATerm[] args = new ATerm[fanout];
        ATerm arg = VisitorBenchmark.buildTerm(depth - 1, fanout);
        int i = 0;
        while (i < fanout) {
            args[i] = arg;
            ++i;
        }
        return factory.makeAppl(fun, args);
    }
}

