/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleSyntaxException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuleClauseCode {
    protected Rule rule;
    protected byte[] code;
    protected Object[] args;
    protected int[] termStart;
    public static final byte GET_CONSTANT = 1;
    public static final byte GET_VARIABLE = 2;
    public static final byte UNIFY_VARIABLE = 3;
    public static final byte GET_TEMP = 4;
    public static final byte UNIFY_TEMP = 18;
    public static final byte PUT_CONSTANT = 5;
    public static final byte PUT_NEW_VARIABLE = 6;
    public static final byte PUT_VARIABLE = 7;
    public static final byte PUT_DEREF_VARIABLE = 20;
    public static final byte PUT_TEMP = 8;
    public static final byte CALL_PREDICATE = 9;
    public static final byte GET_FUNCTOR = 10;
    public static final byte CALL_PREDICATE_INDEX = 23;
    public static final byte CALL_TRIPLE_MATCH = 17;
    public static final byte LAST_CALL_PREDICATE = 19;
    public static final byte CALL_TABLED = 24;
    public static final byte CALL_WILD_TABLED = 25;
    public static final byte PROCEED = 11;
    public static final byte MAKE_FUNCTOR = 12;
    public static final byte CALL_BUILTIN = 13;
    public static final byte CLEAR_VARIABLE = 14;
    public static final byte CLEAR_TEMP = 15;
    public static final byte CLEAR_ARG = 16;
    public static final byte ALLOCATE = 22;
    public static final byte TEST_BOUND = 32;
    public static final byte TEST_UNBOUND = 33;
    public static final int MAX_PERMANENT_VARS = 6;
    public static final int MAX_ARGUMENT_VARS = 8;
    public static final int MAX_TEMPORARY_VARS = 10;
    public static RuleClauseCode returnCodeBlock = new RuleClauseCode(null);

    public RuleClauseCode(Rule rule) {
        this.rule = rule;
    }

    public byte[] getCode() {
        return this.code;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void compile(LPRuleStore lPRuleStore) {
        CompileState compileState = new CompileState(this.rule);
        int n = 0;
        ClauseEntry clauseEntry = this.rule.getHeadElement(0);
        if (!(clauseEntry instanceof TriplePattern)) {
            throw new LPRuleSyntaxException("Heads of backward rules must be triple patterns", this.rule);
        }
        compileState.emitHead((TriplePattern)clauseEntry);
        this.termStart = new int[this.rule.bodyLength()];
        for (int i = n; i < this.rule.bodyLength(); ++i) {
            this.termStart[i] = compileState.p;
            ClauseEntry clauseEntry2 = this.rule.getBodyElement(i);
            if (clauseEntry2 instanceof TriplePattern) {
                compileState.emitBody((TriplePattern)clauseEntry2, lPRuleStore);
                continue;
            }
            if (clauseEntry2 instanceof Functor) {
                compileState.emitBody((Functor)clauseEntry2);
                continue;
            }
            throw new LPRuleSyntaxException("can't create new bRules in an bRule", this.rule);
        }
        this.code = compileState.getFinalCode();
        this.args = compileState.getFinalArgs();
    }

    public int termIndex(int n) {
        int n2;
        if (this.rule == null) {
            return -1;
        }
        for (n2 = 0; n2 < this.rule.bodyLength(); ++n2) {
            if (n > this.termStart[n2]) continue;
            return n2 - 1;
        }
        return n2 - 1;
    }

    public void print(PrintStream printStream) {
        if (this.code == null) {
            printStream.println("Code not available");
        } else {
            int n = 0;
            int n2 = 0;
            block26: while (n2 < this.code.length) {
                byte by = this.code[n2++];
                switch (by) {
                    case 1: {
                        printStream.println("GET_CONSTANT " + this.args[n++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 2: {
                        printStream.println("GET_VARIABLE Y" + this.code[n2++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 3: {
                        printStream.println("UNIFY_VARIABLE Y" + this.code[n2++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 4: {
                        printStream.println("GET_TEMP T" + this.code[n2++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 18: {
                        printStream.println("UNIFY_TEMP T" + this.code[n2++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 5: {
                        printStream.println("PUT_CONSTANT " + this.args[n++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 6: {
                        printStream.println("PUT_NEW_VARIABLE Y" + this.code[n2++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 8: {
                        printStream.println("PUT_TEMP T" + this.code[n2++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 7: {
                        printStream.println("PUT_VARIABLE Y" + this.code[n2++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 20: {
                        printStream.println("PUT_DEREF_VARIABLE Y" + this.code[n2++] + ", A" + this.code[n2++]);
                        continue block26;
                    }
                    case 32: {
                        printStream.println("TEST_BOUND A" + this.code[n2++]);
                        continue block26;
                    }
                    case 33: {
                        printStream.println("TEST_UNBOUND A" + this.code[n2++]);
                        continue block26;
                    }
                    case 9: {
                        printStream.println("CALL_PREDICATE " + this.args[n++]);
                        continue block26;
                    }
                    case 24: {
                        printStream.println("CALL_TABLED ");
                        continue block26;
                    }
                    case 25: {
                        printStream.println("CALL_WILD_TABLED ");
                        continue block26;
                    }
                    case 23: {
                        printStream.println("CALL_PREDICATE_INDEX " + this.args[n++]);
                        continue block26;
                    }
                    case 19: {
                        printStream.println("LAST_CALL_PREDICATE " + this.args[n++]);
                        continue block26;
                    }
                    case 17: {
                        printStream.println("CALL_TRIPLE_MATCH");
                        continue block26;
                    }
                    case 11: {
                        printStream.println("PROCEED");
                        continue block26;
                    }
                    case 12: {
                        printStream.println("MAKE_FUNCTOR " + this.args[n++]);
                        continue block26;
                    }
                    case 10: {
                        printStream.println("GET_FUNCTOR " + this.args[n++]);
                        continue block26;
                    }
                    case 13: {
                        printStream.println("CALL_BUILTIN " + ((Builtin)this.args[n++]).getName() + "/" + this.code[n2++]);
                        continue block26;
                    }
                    case 16: {
                        printStream.println("CLEAR_ARG A" + this.code[n2++]);
                        continue block26;
                    }
                    case 22: {
                        printStream.println("ALLOCATE");
                        continue block26;
                    }
                }
                printStream.println("Unused code: " + by);
            }
        }
    }

    public String toString() {
        if (this.rule == null) {
            return "[anon]";
        }
        return "[" + this.rule.toShortString() + "]";
    }

    public static void main(String[] stringArray) {
        try {
            LPRuleStore lPRuleStore = new LPRuleStore();
            String string = "(?a p ?y) <- (?a p2 ?z).";
            String string2 = "(?a p ?y) <- (?a q2 ?z) (?z q2 ?w).";
            String string3 = "(?a p ?a) <- (?z r2 ?w) (?z r2 ?w).";
            String string4 = "(?a p ?a) <- (?z r2 ?w) (?a r2 ?w).";
            String string5 = "(?a p ?y) <- (?a p ?z), (?z p ?y).";
            String string6 = "(?x p C3) <- (C1 r ?x).";
            String string7 = "(?x p ?y) <- (?x r ?y) (?x q ?y).";
            String string8 = "(?x p ?y) <- (?x p ?z) addOne(?z, ?y).";
            String string9 = "(?x p ?y) <- (?x p ?z) sum(?z, 2, ?y).";
            String string10 = "(?x p ?y) <- (?x p ?v), sum(?v 2 ?y).";
            String string11 = "(b p ?y) <- (a ?y ?v).";
            String string12 = "(?x p ?y) <- (?x p foo(?z, ?y)).";
            String string13 = "(?x p foo(?y,?z)) <- (?x q ?y), (?x q ?z).";
            String string14 = "(?x p ?z) <- (?x e ?z), (?z q ?z).";
            String string15 = "(?x p ?y ) <- bound(?x), (?x p ?y).";
            String string16 = "(a p b ) <- unbound(?x).";
            String string17 = "(?a p ?a) <- (?a q class).";
            String string18 = "(?a p ?a) <- (?a s ?a).";
            String string19 = "(?X p ?T) <- (?X rdf:type c), noValue(?X, p), makeInstance(?X, p, ?T).";
            String string20 = "(a p b ) <- unbound(?x).";
            lPRuleStore.addRule(Rule.parseRule(string20));
            System.out.println("Code for p:");
            List list = lPRuleStore.codeFor(Node.createURI("p"));
            RuleClauseCode ruleClauseCode = (RuleClauseCode)list.get(0);
            ruleClauseCode.print(System.out);
        }
        catch (Exception exception) {
            System.out.println("Problem: " + exception);
            exception.printStackTrace();
        }
    }

    static {
        RuleClauseCode.returnCodeBlock.code = new byte[]{11};
    }

    static class TermIndex {
        int termNumber;
        int index;
        Node_RuleVariable var;

        TermIndex(Node_RuleVariable node_RuleVariable, int n, int n2) {
            this.var = node_RuleVariable;
            this.termNumber = n;
            this.index = n2;
        }
    }

    static class CompileState {
        byte[] code;
        ArrayList args;
        int p;
        private List[] termVarTable;
        private Map varOccurrence = new HashMap();
        private List permanentVars = new ArrayList();
        private List tempVars = new ArrayList();
        int totalOccurrences = 0;
        Set seen = new HashSet();
        Rule rule;

        CompileState(Rule rule) {
            this.classifyVariables(rule);
            this.rule = rule;
            this.code = new byte[10 + this.totalOccurrences + rule.bodyLength() * 10];
            this.args = new ArrayList();
        }

        int emitBindingTests() {
            Functor functor;
            ClauseEntry clauseEntry;
            int n;
            for (n = 0; n < this.rule.bodyLength() && (clauseEntry = this.rule.getBodyElement(n)) instanceof Functor && (functor = (Functor)clauseEntry).getArgLength() == 1; ++n) {
                int n2 = this.aIndex(functor.getArgs()[0]);
                if (n2 < 0) continue;
                if (functor.getName().equals("bound")) {
                    this.code[this.p++] = 32;
                    this.code[this.p++] = (byte)n2;
                    continue;
                }
                if (!functor.getName().equals("unbound")) break;
                this.code[this.p++] = 33;
                this.code[this.p++] = (byte)n2;
            }
            return n;
        }

        int aIndex(Node node) {
            TriplePattern triplePattern = (TriplePattern)this.rule.getHeadElement(0);
            if (triplePattern.getSubject() == node) {
                return 0;
            }
            if (triplePattern.getPredicate() == node) {
                return 1;
            }
            if (triplePattern.getObject() == node) {
                return 2;
            }
            return -1;
        }

        void emitHead(TriplePattern triplePattern) {
            if (this.permanentVars.size() > 0) {
                this.code[this.p++] = 22;
            }
            this.emitHeadGet(triplePattern.getSubject(), 0);
            this.emitHeadGet(triplePattern.getPredicate(), 1);
            this.emitHeadGet(triplePattern.getObject(), 2);
        }

        void emitHeadGet(Node node, int n) {
            if (node instanceof Node_RuleVariable) {
                Node_RuleVariable node_RuleVariable = (Node_RuleVariable)node;
                if (this.isDummy(node_RuleVariable)) {
                    return;
                }
                if (this.isTemp(node_RuleVariable)) {
                    List list = (List)this.varOccurrence.get(node_RuleVariable);
                    if (list.size() != 2 || ((TermIndex)list.get((int)0)).index > 2 || ((TermIndex)list.get((int)0)).index != ((TermIndex)list.get((int)1)).index) {
                        this.code[this.p++] = this.seen.add(node_RuleVariable) ? 4 : 18;
                        this.code[this.p++] = (byte)node_RuleVariable.getIndex();
                        this.code[this.p++] = (byte)n;
                    }
                } else {
                    this.code[this.p++] = this.seen.add(node_RuleVariable) ? 2 : 3;
                    this.code[this.p++] = (byte)node_RuleVariable.getIndex();
                    this.code[this.p++] = (byte)n;
                }
            } else if (Functor.isFunctor(node)) {
                Functor functor = (Functor)node.getLiteral().getValue();
                this.code[this.p++] = 10;
                this.args.add(functor);
                Node[] nodeArray = functor.getArgs();
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.emitHeadGet(nodeArray[i], i + 3);
                }
            } else {
                this.code[this.p++] = 1;
                this.code[this.p++] = (byte)n;
                this.args.add(node);
            }
        }

        void emitBody(TriplePattern triplePattern, LPRuleStore lPRuleStore) {
            boolean bl = false;
            this.emitBodyPut(triplePattern.getSubject(), 0, false);
            this.emitBodyPut(triplePattern.getPredicate(), 1, false);
            this.emitBodyPut(triplePattern.getObject(), 2, false);
            List list = lPRuleStore.codeFor(triplePattern);
            if (list == null || list.size() == 0) {
                this.code[this.p++] = 17;
            } else if (triplePattern.getPredicate().isVariable()) {
                this.code[this.p++] = 24;
            } else if (lPRuleStore.isTabled(triplePattern)) {
                this.code[this.p++] = triplePattern.getPredicate().isVariable() ? 25 : 24;
            } else {
                this.code[this.p++] = this.permanentVars.size() == 0 ? 19 : (lPRuleStore.isIndexedPredicate(triplePattern.getPredicate()) && triplePattern.getObject().isVariable() ? 23 : 9);
                this.args.add(list);
            }
        }

        void emitBodyPut(Node node, int n, boolean bl) {
            if (node instanceof Node_RuleVariable) {
                Node_RuleVariable node_RuleVariable = (Node_RuleVariable)node;
                if (this.isDummy(node_RuleVariable)) {
                    this.code[this.p++] = 16;
                    this.code[this.p++] = (byte)n;
                    return;
                }
                if (this.isTemp(node_RuleVariable)) {
                    List list = (List)this.varOccurrence.get(node_RuleVariable);
                    if (list.size() != 2 || ((TermIndex)list.get((int)0)).index != ((TermIndex)list.get((int)1)).index) {
                        this.code[this.p++] = 8;
                        this.code[this.p++] = (byte)node_RuleVariable.getIndex();
                        this.code[this.p++] = (byte)n;
                    }
                } else {
                    this.code[this.p++] = !this.seen.add(node_RuleVariable) ? (bl ? 20 : 7) : 6;
                    this.code[this.p++] = (byte)node_RuleVariable.getIndex();
                    this.code[this.p++] = (byte)n;
                }
            } else if (Functor.isFunctor(node)) {
                Functor functor = (Functor)node.getLiteral().getValue();
                Node[] nodeArray = functor.getArgs();
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.emitBodyPut(nodeArray[i], i + 3, bl);
                }
                this.code[this.p++] = 12;
                this.args.add(functor);
            } else {
                this.code[this.p++] = 5;
                this.code[this.p++] = (byte)n;
                this.args.add(node);
            }
        }

        void emitBody(Functor functor) {
            Node[] nodeArray = functor.getArgs();
            Builtin builtin = functor.getImplementor();
            if (builtin == null) {
                throw new LPRuleSyntaxException("Unknown builtin operation " + functor.getName(), this.rule);
            }
            if (builtin.getArgLength() != 0 && builtin.getArgLength() != nodeArray.length) {
                throw new LPRuleSyntaxException("Wrong number of arguments to functor " + functor.getName() + " expected " + functor.getArgLength(), this.rule);
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                this.emitBodyPut(node, i, true);
            }
            this.code[this.p++] = 13;
            this.code[this.p++] = (byte)nodeArray.length;
            this.args.add(builtin);
        }

        byte[] getFinalCode() {
            this.code[this.p++] = 11;
            byte[] byArray = new byte[this.p];
            System.arraycopy(this.code, 0, byArray, 0, this.p);
            return byArray;
        }

        Object[] getFinalArgs() {
            return this.args.toArray();
        }

        void classifyVariables(Rule rule) {
            List list;
            int n;
            this.termVarTable = new List[rule.bodyLength() + 1];
            this.termVarTable[0] = this.termVars(rule.getHeadElement(0));
            this.totalOccurrences += this.termVarTable[0].size();
            for (n = 0; n < rule.bodyLength(); ++n) {
                this.termVarTable[n + 1] = this.termVars(rule.getBodyElement(n));
                this.totalOccurrences += this.termVarTable[n + 1].size();
            }
            for (n = 0; n < rule.bodyLength() + 1; ++n) {
                list = this.termVarTable[n];
                for (int i = 0; i < list.size(); ++i) {
                    Node node = (Node)list.get(i);
                    if (!node.isVariable()) continue;
                    Node_RuleVariable node_RuleVariable = (Node_RuleVariable)node;
                    ArrayList<TermIndex> arrayList = (ArrayList<TermIndex>)this.varOccurrence.get(node_RuleVariable);
                    if (arrayList == null) {
                        arrayList = new ArrayList<TermIndex>();
                        this.varOccurrence.put(node_RuleVariable, arrayList);
                    }
                    arrayList.add(new TermIndex(node_RuleVariable, n, i));
                }
            }
            Iterator iterator = this.varOccurrence.values().iterator();
            while (iterator.hasNext()) {
                list = (List)iterator.next();
                Node_RuleVariable node_RuleVariable = null;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    TermIndex termIndex = (TermIndex)iterator2.next();
                    node_RuleVariable = termIndex.var;
                    int n2 = termIndex.termNumber;
                    if (n2 == 0) {
                        bl = true;
                    } else if (n2 > 1) {
                        bl2 = true;
                    }
                    if (n2 <= 0 || !(rule.getBodyElement(n2 - 1) instanceof Functor)) continue;
                    bl3 = true;
                }
                if (this.isDummy(node_RuleVariable)) continue;
                if (bl2 || !bl) {
                    this.permanentVars.add(node_RuleVariable);
                    continue;
                }
                this.tempVars.add(node_RuleVariable);
            }
            if (this.permanentVars.size() > 6) {
                throw new LPRuleSyntaxException("Rule too complex for current implementation\nRule clauses are limited to 6permanent variables\n", rule);
            }
            if (this.tempVars.size() > 10) {
                throw new LPRuleSyntaxException("Rule too complex for current implementation\nRule clauses are limited to 10temporary variables\n", rule);
            }
        }

        boolean isTemp(Node_RuleVariable node_RuleVariable) {
            return !this.isDummy(node_RuleVariable) && !this.permanentVars.contains(node_RuleVariable);
        }

        boolean isDummy(Node_RuleVariable node_RuleVariable) {
            List list = (List)this.varOccurrence.get(node_RuleVariable);
            return list == null || list.size() <= 1;
        }

        private List termVars(ClauseEntry clauseEntry) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (clauseEntry instanceof TriplePattern) {
                TriplePattern triplePattern = (TriplePattern)clauseEntry;
                arrayList.add(triplePattern.getSubject());
                arrayList.add(triplePattern.getPredicate());
                Node node = triplePattern.getObject();
                if (Functor.isFunctor(node)) {
                    arrayList.add(node);
                    arrayList.addAll(this.termVars((Functor)node.getLiteral().getValue()));
                } else {
                    arrayList.add(node);
                }
            } else if (clauseEntry instanceof Functor) {
                Node[] nodeArray = ((Functor)clauseEntry).getArgs();
                for (int i = 0; i < nodeArray.length; ++i) {
                    arrayList.add(nodeArray[i]);
                }
            }
            return arrayList;
        }
    }
}

