/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdql.EvalTypeException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Settable;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.WorkingVar;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import java.io.PrintWriter;

public class Q_GreaterThanOrEqual
extends SimpleNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    private String printName = "ge";
    private String opSymbol = ">=";

    Q_GreaterThanOrEqual(int n) {
        super(n);
    }

    Q_GreaterThanOrEqual(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        Value value = this.left.eval(query, resultBinding);
        Value value2 = this.right.eval(query, resultBinding);
        if (!value.isNumber()) {
            throw new EvalTypeException("Q_GreaterThanOrEqual: Wanted a numeric: " + value);
        }
        if (!value2.isNumber()) {
            throw new EvalTypeException("Q_GreaterThanOrEqual: Wanted a numeric: " + value2);
        }
        Settable settable = value instanceof Settable ? (Settable)value : (value2 instanceof Settable ? (Settable)value2 : new WorkingVar());
        boolean bl = value.isInt() && value2.isInt() ? value.getInt() >= value2.getInt() : value.getDouble() >= value2.getDouble();
        settable.setBoolean(bl);
        return settable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_GreaterThanOrEqual: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.left, this.right, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

