/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.query.SimpleTripleSorter;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TripleSorter;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

public abstract class AbstractTestQuery
extends GraphTestBase {
    protected Query Q;
    protected Node X = AbstractTestQuery.node("?x");
    protected Node Y = AbstractTestQuery.node("?y");
    protected Node Z = AbstractTestQuery.node("?z");
    protected Graph empty;
    protected Graph single;
    private static final String[][] tests = new String[][]{{"", "pigs might fly", "", ""}, {"", "", "pigs might fly", ""}, {"", "a pings b; b pings c", "a pings _x; _x pings c", "a pings b; b pings c"}, {"", "a pings b; b pings c; a pings x; x pings c", "a pings _x; _x pings c", "a pings b; b pings c; a pings x; x pings c"}};
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$query$test$QueryTest;

    public AbstractTestQuery(String string) {
        super(string);
    }

    public abstract Graph getGraph();

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$query$test$QueryTest == null ? (class$com$hp$hpl$jena$graph$query$test$QueryTest = AbstractTestQuery.class$("com.hp.hpl.jena.graph.query.test.QueryTest")) : class$com$hp$hpl$jena$graph$query$test$QueryTest);
    }

    public Graph getGraphWith(String string) {
        return AbstractTestQuery.graphAdd(this.getGraph(), string);
    }

    public void setUp() {
        this.Q = new Query();
        this.empty = this.getGraphWith("");
        this.single = this.getGraphWith("spindizzies drive cities");
    }

    private void testTreeQuery(String string, String string2, String string3, String string4) {
        Graph graph = this.getGraphWith(string2);
        Graph graph2 = this.getGraphWith(string3);
        Graph graph3 = graph.queryHandler().prepareTree(graph2).executeTree();
        if (string.equals("")) {
            string = "checking {" + string2 + "} against {" + string3 + "} should give {" + string4 + "}" + " not " + graph3;
        }
        AbstractTestQuery.assertEquals(string, this.getGraphWith(string4), graph3);
    }

    private void testTreeQuery(String string, String string2, String string3) {
        this.testTreeQuery("checking", string, string2, string3);
    }

    public void testManyThings() {
        for (int i = 0; i < tests.length; ++i) {
            this.testTreeQuery(tests[i][0], tests[i][1], tests[i][2], tests[i][3]);
        }
    }

    public void testAtomicTreeQuery() {
        this.testTreeQuery("pigs might fly; birds will joke; cats must watch", "birds will joke", "birds will joke");
    }

    public void testCompositeTreeQuery() {
        this.testTreeQuery("pigs might fly; birds will joke; cats must watch", "birds will joke; pigs might fly", "pigs might fly; birds will joke");
    }

    public void testChainedTreeQuery() {
        this.testTreeQuery("a pings b; b pings c; c pings d", "a pings b; b pings c", "a pings b; b pings c");
    }

    public void testBinding1() {
        Graph graph = this.getGraphWith("rice grows quickly");
        Query query = new Query();
        Node node = AbstractTestQuery.node("?v1");
        Node node2 = AbstractTestQuery.node("?v3");
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query.addMatch(node, AbstractTestQuery.node("grows"), node2), new Node[]{node, node2});
        Domain domain = (Domain)bindingQueryPlan.executeBindings().next();
        AbstractTestQuery.assertEquals((String)"binding subject to rice", (Object)domain.get(0), (Object)AbstractTestQuery.node("rice"));
        AbstractTestQuery.assertEquals((String)"binding object to quickly", (Object)domain.get(1), (Object)AbstractTestQuery.node("quickly"));
    }

    public void testBinding2() {
        int n;
        Graph graph = this.getGraphWith("rice grows quickly; time isan illusion");
        String[][] stringArrayArray = new String[][]{{"time", "isan", "illusion"}, {"rice", "grows", "quickly"}};
        boolean[] blArray = new boolean[]{false, false};
        Query query = new Query();
        Node node = AbstractTestQuery.node("?v1");
        Node node2 = AbstractTestQuery.node("?v2");
        Node node3 = AbstractTestQuery.node("?v3");
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query.addMatch(node, node2, node3), new Node[]{node, node2, node3});
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings();
        block0: for (n = 0; n < stringArrayArray.length; ++n) {
            if (!extendedIterator.hasNext()) {
                AbstractTestQuery.fail((String)"wanted some more results");
            }
            Domain domain = (Domain)extendedIterator.next();
            for (int i = 0; i < stringArrayArray.length; ++i) {
                if (blArray[i]) continue;
                boolean bl = true;
                for (int j = 0; j < 3; ++j) {
                    if (domain.get(j).equals(AbstractTestQuery.node(stringArrayArray[i][j]))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                blArray[i] = true;
                continue block0;
            }
        }
        for (n = 0; n < stringArrayArray.length; ++n) {
            if (blArray[n]) continue;
            AbstractTestQuery.assertTrue((String)"binding failure", (boolean)false);
        }
        AbstractTestQuery.assertFalse((String)"iterator should be empty", (boolean)extendedIterator.hasNext());
    }

    public void testMultiplePatterns() {
        Graph graph = this.getGraphWith("ben wrote Clayface; Starfish ingenre SF; Clayface ingenre Geology; bill wrote Starfish");
        Query query = new Query();
        Node node = AbstractTestQuery.node("?X");
        Node node2 = AbstractTestQuery.node("?A");
        query.addMatch(node, AbstractTestQuery.node("wrote"), node2).addMatch(node2, AbstractTestQuery.node("ingenre"), AbstractTestQuery.node("SF"));
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node});
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings();
        if (extendedIterator.hasNext()) {
            Domain domain = (Domain)extendedIterator.next();
            if (domain.size() > 0) {
                if (domain.get(0).equals(AbstractTestQuery.node("bill"))) {
                    if (extendedIterator.hasNext()) {
                        System.out.println("! failed: more than one multiple pattern answer: " + extendedIterator.next());
                    }
                } else {
                    System.out.println("! failed: multiple pattern answer should be 'bill'");
                }
            } else {
                System.out.println("! failed: multiple pattern answer should have one element");
            }
        } else {
            System.out.println("! failed: multiple pattern query should have an answer");
        }
    }

    public void testNodeVariablesA() {
        Graph graph = this.getGraphWith("storms hit England");
        Node node = AbstractTestQuery.node("?spoo");
        this.Q.addMatch(node, AbstractTestQuery.node("hit"), AbstractTestQuery.node("England"));
        ExtendedIterator extendedIterator = graph.queryHandler().prepareBindings(this.Q, new Node[]{node}).executeBindings();
        AbstractTestQuery.assertTrue((String)"tnv: it has a solution", (boolean)extendedIterator.hasNext());
        AbstractTestQuery.assertEquals((String)"", (Object)AbstractTestQuery.node("storms"), ((List)extendedIterator.next()).get(0));
        AbstractTestQuery.assertFalse((String)"tnv: just the one solution", (boolean)extendedIterator.hasNext());
    }

    public void testNodeVariablesB() {
        Graph graph = this.getGraphWith("storms hit England");
        Node node = AbstractTestQuery.node("?spoo");
        Node node2 = AbstractTestQuery.node("?flarn");
        this.Q.addMatch(node, AbstractTestQuery.node("hit"), node2);
        ExtendedIterator extendedIterator = graph.queryHandler().prepareBindings(this.Q, new Node[]{node2, node}).executeBindings();
        AbstractTestQuery.assertTrue((String)"tnv: it has a solution", (boolean)extendedIterator.hasNext());
        List list = (List)extendedIterator.next();
        AbstractTestQuery.assertEquals((String)"tnvB", (Object)AbstractTestQuery.node("storms"), list.get(1));
        AbstractTestQuery.assertEquals((String)"tnvB", (Object)AbstractTestQuery.node("England"), list.get(0));
        AbstractTestQuery.assertFalse((String)"tnv: just the one solution", (boolean)extendedIterator.hasNext());
    }

    public Set nodeSet(String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(AbstractTestQuery.node(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    public void testGraphConstraints(String string, String string2, String string3) {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Node node = AbstractTestQuery.node("?O");
        Query query = new Query();
        query.addMatch(Query.ANY, Query.ANY, node);
        Graph graph = this.getGraphWith("pigs fly south; dogs fly badly; plans fly flat");
        query.addConstraint(this.getGraphWith(string2));
        Set set = AbstractTestQuery.iteratorToSet(graph.queryHandler().prepareBindings(query, new Node[]{node}).executeBindings().mapWith(map1));
        AbstractTestQuery.assertEquals((String)"tgs", (Object)this.nodeSet(string3), (Object)set);
    }

    public void testGraphConstraints() {
        this.testGraphConstraints("tgs A", "", "south flat badly");
        this.testGraphConstraints("tgs B", "?O &ne badly", "south flat");
        this.testGraphConstraints("tgs C", "?O &ne badly; ?O &ne flat", "south");
    }

    public void testSeveralGraphConstraints() {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Node node = AbstractTestQuery.node("?O");
        Query query = new Query();
        query.addMatch(Query.ANY, Query.ANY, node);
        Graph graph = this.getGraphWith("pigs fly south; dogs fly badly; plans fly flat");
        query.addConstraint(this.getGraphWith("?O &ne badly"));
        query.addConstraint(this.getGraphWith("?O &ne flat"));
        Set set = AbstractTestQuery.iteratorToSet(graph.queryHandler().prepareBindings(query, new Node[]{node}).executeBindings().mapWith(map1));
        AbstractTestQuery.assertEquals((String)"tsgs", (Object)this.nodeSet("south"), (Object)set);
    }

    public void testBindingQuery() {
        Graph graph = this.getGraphWith("");
        Graph graph2 = this.getGraphWith("pigs might fly; cats chase mice; dogs chase cars; cats might purr");
        Node[] nodeArray = new Node[]{};
        AbstractTestQuery.assertFalse((String)"empty graph, no bindings", (boolean)graph.queryHandler().prepareBindings(new Query().addMatch(Query.ANY, Query.ANY, Query.ANY), nodeArray).executeBindings().hasNext());
        AbstractTestQuery.assertTrue((String)"full graph, > 0 bindings", (boolean)graph2.queryHandler().prepareBindings(new Query(), nodeArray).executeBindings().hasNext());
    }

    public static List iteratorToList(ClosableIterator closableIterator) {
        ArrayList arrayList = new ArrayList();
        while (closableIterator.hasNext()) {
            arrayList.add(closableIterator.next());
        }
        return arrayList;
    }

    public void testEmpty() {
        List list = AbstractTestQuery.iteratorToList(this.Q.executeBindings(this.empty, new Node[0]));
        AbstractTestQuery.assertEquals((String)"testEmpty: select [] from {} => 1 empty binding [size]", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        AbstractTestQuery.assertEquals((String)"testEmpty: select [] from {} => 1 empty binding [width]", (int)domain.size(), (int)0);
    }

    public void testOneMatch() {
        this.Q.addMatch(this.X, Query.ANY, Query.ANY);
        List list = AbstractTestQuery.iteratorToList(this.Q.executeBindings(this.single, new Node[]{this.X}));
        AbstractTestQuery.assertEquals((String)"select X from {spindizzies drive cities} => 1 binding [size]", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        AbstractTestQuery.assertEquals((String)"select X from {spindizzies drive cities} => 1 binding [width]", (int)domain.size(), (int)1);
        AbstractTestQuery.assertTrue((String)"select X from {spindizzies drive cities} => 1 binding [value]", (boolean)domain.get(0).equals(AbstractTestQuery.node("spindizzies")));
    }

    public void testMismatch() {
        this.Q.addMatch(this.X, this.X, this.X);
        List list = AbstractTestQuery.iteratorToList(this.Q.executeBindings(this.single, new Node[]{this.X}));
        AbstractTestQuery.assertEquals((String)"bindings mismatch (X X X)", (int)list.size(), (int)0);
    }

    public void testXXXMatch1() {
        this.Q.addMatch(this.X, this.X, this.X);
        Graph graph = this.getGraphWith("ring ring ring");
        List list = AbstractTestQuery.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        AbstractTestQuery.assertEquals((String)"bindings match (X X X)", (int)list.size(), (int)1);
    }

    public HashSet setFrom(Node[] nodeArray) {
        HashSet<Node> hashSet = new HashSet<Node>(nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            hashSet.add(nodeArray[i]);
        }
        return hashSet;
    }

    public void testXXXMatch3() {
        this.Q.addMatch(this.X, this.X, this.X);
        Graph graph = this.getGraphWith("ring ring ring; ding ding ding; ping ping ping");
        List list = AbstractTestQuery.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        AbstractTestQuery.assertEquals((String)"bindings match (X X X)", (int)list.size(), (int)3);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Domain domain = (Domain)list.get(i);
            AbstractTestQuery.assertEquals((String)"one bound variable", (int)domain.size(), (int)1);
            hashSet.add(domain.get(0));
        }
        HashSet hashSet2 = this.setFrom(new Node[]{AbstractTestQuery.node("ring"), AbstractTestQuery.node("ding"), AbstractTestQuery.node("ping")});
        AbstractTestQuery.assertEquals((String)"testMatch getting {ring ding ping}", hashSet, (Object)hashSet2);
    }

    public void testTwoPatterns() {
        Node node = AbstractTestQuery.node("reads");
        Node node2 = AbstractTestQuery.node("inGenre");
        Graph graph = this.getGraphWith("chris reads blish; blish inGenre SF");
        this.Q.addMatch(this.X, node, this.Y);
        this.Q.addMatch(this.Y, node2, this.Z);
        List list = AbstractTestQuery.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X, this.Z}));
        AbstractTestQuery.assertTrue((String)"testTwoPatterns: one binding", (list.size() == 1 ? 1 : 0) != 0);
        Domain domain = (Domain)list.get(0);
        AbstractTestQuery.assertTrue((String)"testTwoPatterns: width 2", (domain.size() >= 2 ? 1 : 0) != 0);
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: X = chris", (Object)domain.get(0), (Object)AbstractTestQuery.node("chris"));
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: Y = SF", (Object)domain.get(1), (Object)AbstractTestQuery.node("SF"));
    }

    public void testGraphQuery() {
        Graph graph = this.getGraphWith("?X reads ?Y; ?Y inGenre ?Z");
        Graph graph2 = this.getGraphWith("chris reads blish; blish inGenre SF");
        Query query = new Query(graph);
        List list = AbstractTestQuery.iteratorToList(query.executeBindings(graph2, new Node[]{AbstractTestQuery.node("?X"), AbstractTestQuery.node("?Z")}));
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: one binding", (int)1, (int)list.size());
        Domain domain = (Domain)list.get(0);
        AbstractTestQuery.assertTrue((String)"testTwoPatterns: width 2", (domain.size() >= 2 ? 1 : 0) != 0);
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: X = chris", (Object)domain.get(0), (Object)AbstractTestQuery.node("chris"));
        AbstractTestQuery.assertEquals((String)"testTwoPatterns: Y = SF", (Object)domain.get(1), (Object)AbstractTestQuery.node("SF"));
    }

    public void testTwoGraphs() {
        Graph graph = this.getGraphWith("chris reads blish; chris reads norton; chris eats curry");
        Graph graph2 = this.getGraphWith("blish inGenre SF; curry inGenre food");
        Node node = AbstractTestQuery.node("reads");
        Node node2 = AbstractTestQuery.node("inGenre");
        this.Q.addMatch("a", this.X, node, this.Y).addMatch("b", this.Y, node2, this.Z);
        Query.ArgMap argMap = this.Q.args().put("a", graph).put("b", graph2);
        List list = AbstractTestQuery.iteratorToList(this.Q.executeBindings(argMap, new Node[]{this.X, this.Z}));
        AbstractTestQuery.assertEquals((String)"testTwoGraphs: one binding", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        AbstractTestQuery.assertTrue((String)"testTwoGraphs: width 2", (domain.size() >= 2 ? 1 : 0) != 0);
        AbstractTestQuery.assertEquals((String)"testTwoGraphs: X = chris", (Object)domain.get(0), (Object)AbstractTestQuery.node("chris"));
        AbstractTestQuery.assertEquals((String)"testTwoGraphs: Y = SF", (Object)domain.get(1), (Object)AbstractTestQuery.node("SF"));
    }

    private void helpConstraint(String string, Graph graph, int n) {
        Query query = new Query();
        Graph graph2 = this.getGraphWith("blish wrote CIF; blish wrote VOR; hambly wrote Darwath; feynman mechanicked quanta");
        query.addMatch(this.X, AbstractTestQuery.node("wrote"), Query.ANY);
        query.addConstraint(graph);
        List list = AbstractTestQuery.iteratorToList(query.executeBindings(graph2, new Node[]{this.X}));
        AbstractTestQuery.assertEquals((String)("testConstraint " + string + ": number of bindings"), (int)n, (int)list.size());
    }

    public void testConstraint() {
        this.helpConstraint("none", this.getGraphWith(""), 3);
        this.helpConstraint("X /= blish", this.getGraphWith("?x &ne blish"), 1);
        this.helpConstraint("X /= blish & X /= hambly", this.getGraphWith("?x &ne blish; ?x &ne hambly"), 0);
    }

    public void testConstraintTwo() {
        Graph graph = this.getGraphWith("blish wrote CIF; blish wrote VOR; hambly wrote Darwath; feynman mechanicked quanta");
        this.Q.addMatch(this.X, AbstractTestQuery.node("wrote"), this.Y);
        this.Q.addConstraint(this.getGraphWith("?x &ne ?y"));
        List list = AbstractTestQuery.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        AbstractTestQuery.assertEquals((String)"testConstraint Two: number of bindings", (int)list.size(), (int)3);
    }

    private void helpConstraintThree(String string, Graph graph, int n) {
        Query query = new Query();
        Graph graph2 = this.getGraphWith("brust wrote jhereg; hedgehog hacked code; angel age 230; brust wrote 230");
        query.addConstraint(graph);
        query.addMatch(this.X, this.Y, this.Z);
        List list = AbstractTestQuery.iteratorToList(query.executeBindings(graph2, new Node[]{this.X, this.Z}));
        AbstractTestQuery.assertEquals((String)("testConstraint " + string + ": number of bindings"), (int)n, (int)list.size());
    }

    public void testConstraintThree() {
        this.helpConstraintThree("testConstraintThree 1:", this.getGraphWith("?x &eq brust"), 2);
        this.helpConstraintThree("testConstraintThree 2:", this.getGraphWith("?y &eq hacked"), 1);
        this.helpConstraintThree("testConstraintThree 3:", this.getGraphWith("?z &eq 230"), 2);
        this.helpConstraintThree("testConstraintThree 4:", this.getGraphWith("?z &eq 230"), 2);
    }

    public void testConstraintFour() {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Query query = new Query();
        Graph graph = this.getGraphWith("bill pinged ben; ben pinged weed; weed pinged weed; bill ignored bill");
        query.addMatch(this.X, AbstractTestQuery.node("pinged"), this.Y);
        query.addConstraint(this.X, Query.NE, this.Y);
        Set set = AbstractTestQuery.iteratorToSet(query.executeBindings(graph, new Node[]{this.X}).mapWith(map1));
        AbstractTestQuery.assertEquals((String)"", (Object)this.setFrom(new Node[]{AbstractTestQuery.node("bill"), AbstractTestQuery.node("ben")}), (Object)set);
    }

    public void testStringResults() {
        Graph graph = this.getGraphWith("ding dong dilly");
        Query query = new Query().addMatch(this.X, this.Y, Query.ANY);
        List list = AbstractTestQuery.iteratorToList(query.executeBindings(graph, new Node[]{this.X, this.Y}));
        AbstractTestQuery.assertEquals((String)"one result back by name", (int)list.size(), (int)1);
        AbstractTestQuery.assertEquals((String)"x = ding", (Object)((Domain)list.get(0)).get(0), (Object)AbstractTestQuery.node("ding"));
    }

    public void testMissingVariable() {
        Graph graph = this.getGraphWith("x y z");
        Query query = new Query();
        List list = AbstractTestQuery.iteratorToList(query.executeBindings(graph, new Node[]{this.X, this.Y}));
        List list2 = (List)query.executeBindings(graph, new Node[]{this.X, this.Y}).next();
        AbstractTestQuery.assertEquals((String)"undefined variables get null", null, list2.get(0));
    }

    public void testDisconnected() {
        Graph graph = this.getGraphWith("x pred1 foo; y pred2 bar");
        Query query = new Query(this.getGraphWith("?X ?? foo; ?Y ?? bar"));
        List list = AbstractTestQuery.iteratorToList(query.executeBindings(graph, AbstractTestQuery.nodes("?X ?Y")));
        AbstractTestQuery.assertEquals((int)1, (int)list.size());
        AbstractTestQuery.assertEquals((Object)AbstractTestQuery.node("x"), ((List)list.get(0)).get(0));
        AbstractTestQuery.assertEquals((Object)AbstractTestQuery.node("y"), ((List)list.get(0)).get(1));
    }

    public void testQueryTripleOrder() {
        Triple triple = Triple.create("A B C");
        Triple triple2 = Triple.create("D E F");
        List<Triple> list = Arrays.asList(triple, triple2);
        List list2 = this.getTriplesFromQuery(list);
        AbstractTestQuery.assertEquals(list, (Object)list2);
    }

    private List getTriplesFromQuery(List list) {
        Query query = new Query();
        final Triple[][] tripleArray = new Triple[1][];
        GraphBase graphBase = new GraphBase(){

            public ExtendedIterator find(TripleMatch tripleMatch) {
                return new NiceIterator();
            }

            public QueryHandler queryHandler() {
                return new SimpleQueryHandler(this, this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Stage patternStage(Mapping mapping, Graph graph, Triple[] tripleArray) {
                        if (tripleArray.length > 1) {
                            4.access$000(this.this$1)[0] = tripleArray;
                        }
                        return super.patternStage(mapping, graph, tripleArray);
                    }
                };
            }

            static /* synthetic */ Triple[][] access$000(4 var0) {
                return var0.tripleArray;
            }
        };
        for (int i = 0; i < list.size(); ++i) {
            query.addMatch((Triple)list.get(i));
        }
        query.executeBindings(graphBase, AbstractTestQuery.nodes(""));
        return Arrays.asList(tripleArray[0]);
    }

    public void testVariableCount() {
        this.assertCount(0, "");
        this.assertCount(0, "x R y");
        this.assertCount(1, "?x R y");
        this.assertCount(1, "?x R y", "?x");
        this.assertCount(2, "?x R y", "?z");
        this.assertCount(1, "?x R ?x");
        this.assertCount(2, "?x R ?y");
        this.assertCount(3, "?x R ?y", "?z");
        this.assertCount(3, "?x ?R ?y");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c", "?x");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c", "?x ?c");
        this.assertCount(6, "?x ?R ?y; ?a ?S ?c", "?x ?y ?c");
        this.assertCount(7, "?x ?R ?y; ?a ?S ?c", "?dog");
        this.assertCount(8, "?x ?R ?y; ?a ?S ?c", "?dog ?cat ?x");
        this.assertCount(18, "?a ?b ?c; ?d ?e ?f; ?g ?h ?i; ?j ?k ?l; ?m ?n ?o; ?p ?q ?r");
    }

    public void assertCount(int n, String string) {
        this.assertCount(n, string, "");
    }

    public void assertCount(int n, String string, String string2) {
        Graph graph = this.getGraphWith("");
        Query query = new Query();
        Triple[] tripleArray = AbstractTestQuery.tripleArray(string);
        for (int i = 0; i < tripleArray.length; ++i) {
            query.addMatch(tripleArray[i]);
        }
        query.executeBindings(graph, AbstractTestQuery.nodes(string2));
        AbstractTestQuery.assertEquals((int)n, (int)query.getVariableCount());
    }

    public void testQueryConstraintUnbound() {
        Query query = new Query().addConstraint(Query.X, Query.NE, Query.Y).addMatch(Query.X, Query.ANY, Query.X);
        Graph graph = this.getGraphWith("x R x; x R y");
        try {
            ExtendedIterator extendedIterator = query.executeBindings(graph, new Node[]{Query.X});
            AbstractTestQuery.fail((String)"should spot unbound variable");
        }
        catch (Query.UnboundVariableException unboundVariableException) {
            // empty catch block
        }
    }

    public void testCloseQuery() {
        int n;
        Graph graph = this.getGraphWith("x R y; a P b; i L j; d X f; h S g; no more heroes");
        for (int i = 0; i < 1000; ++i) {
            AbstractTestQuery.graphAdd(graph, "ping pong X" + i);
        }
        Query query = new Query().addMatch(Query.S, Query.P, Query.O);
        ArrayList arrayList = new ArrayList();
        ExtendedIterator extendedIterator = query.executeBindings(graph, arrayList, new Node[]{Query.P});
        extendedIterator.next();
        for (n = 0; n < arrayList.size(); ++n) {
            AbstractTestQuery.assertFalse((boolean)((Stage)arrayList.get(n)).isClosed());
        }
        extendedIterator.close();
        for (n = 0; n < arrayList.size(); ++n) {
            AbstractTestQuery.assertTrue((boolean)((Stage)arrayList.get(n)).isClosed());
        }
    }

    public void testTripleSorting() {
        Graph graph = this.dataGraph();
        Map map = this.getAnswer(graph, Query.dontSort);
        AbstractTestQuery.assertEquals((int)1, (int)map.size());
        AbstractTestQuery.assertEquals((Object)new Integer(1), map.get(Arrays.asList(AbstractTestQuery.nodes("a d"))));
        AbstractTestQuery.assertEquals((Object)map, (Object)this.getAnswer(graph, Query.dontSort));
        AbstractTestQuery.assertEquals((Object)map, (Object)this.getAnswer(graph, this.fiddle(0, 2, 1)));
        AbstractTestQuery.assertEquals((Object)map, (Object)this.getAnswer(graph, this.fiddle(1, 0, 2)));
        AbstractTestQuery.assertEquals((Object)map, (Object)this.getAnswer(graph, this.fiddle(1, 2, 0)));
        AbstractTestQuery.assertEquals((Object)map, (Object)this.getAnswer(graph, this.fiddle(2, 1, 0)));
        AbstractTestQuery.assertEquals((Object)map, (Object)this.getAnswer(graph, this.fiddle(2, 0, 1)));
    }

    protected TripleSorter fiddle(final int n, final int n2, final int n4) {
        return new TripleSorter(){

            public Triple[] sort(Triple[] tripleArray) {
                return new Triple[]{tripleArray[n], tripleArray[n2], tripleArray[n4]};
            }
        };
    }

    protected Graph dataGraph() {
        Graph graph = this.getGraph();
        AbstractTestQuery.graphAdd(graph, "a SPOO d; a X b; b Y c");
        return graph;
    }

    protected Map getAnswer(Graph graph, TripleSorter tripleSorter) {
        HashMap hashMap = new HashMap();
        Query query = new Query();
        query.addMatch(AbstractTestQuery.triple("?a ?? ?d ")).addMatch(AbstractTestQuery.triple("?a X ?b")).addMatch(AbstractTestQuery.triple("?b Y ?c"));
        query.addConstraint(AbstractTestQuery.node("?d"), Query.NE, AbstractTestQuery.node("?b"));
        Node[] nodeArray = AbstractTestQuery.nodes("?a ?d");
        query.setTripleSorter(tripleSorter);
        ExtendedIterator extendedIterator = query.executeBindings(graph, nodeArray);
        while (extendedIterator.hasNext()) {
            this.addAnswer(hashMap, (List)extendedIterator.next(), nodeArray.length);
        }
        return hashMap;
    }

    protected void addAnswer(Map map, List list, int n) {
        List list2 = list.subList(0, n);
        Integer n2 = (Integer)map.get(list2);
        if (n2 == null) {
            n2 = new Integer(0);
        }
        map.put(list2, new Integer(n2 + 1));
    }

    public void testQueryOptimisation() {
        int n = this.queryCount(Query.dontSort);
        int n2 = this.queryCount(new SimpleTripleSorter());
        if (n2 > n) {
            AbstractTestQuery.fail((String)("optimisation " + n2 + " yet plain " + n));
        }
    }

    int queryCount(TripleSorter tripleSorter) {
        CountingGraph countingGraph = this.bigCountingGraph();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 3; ++k) {
                    AbstractTestQuery.graphAdd(countingGraph, "a" + i + " X" + (k == 0 ? "" : k + "") + " b" + j);
                }
            }
        }
        AbstractTestQuery.graphAdd(countingGraph, "a SPOO d; a X b; b Y c");
        this.getAnswer(countingGraph, tripleSorter);
        return countingGraph.getCount();
    }

    CountingGraph bigCountingGraph() {
        Graph graph = this.getGraph();
        return new CountingGraph(graph);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CountingGraph
    extends WrappedGraph {
        int counter;
        private QueryHandler qh = new SimpleQueryHandler(this);

        public QueryHandler queryHandler() {
            return this.qh;
        }

        CountingGraph(Graph graph) {
            super(graph);
        }

        public ExtendedIterator find(Node node, Node node2, Node node3) {
            return this.find(Triple.createMatch(node, node2, node3));
        }

        public ExtendedIterator find(TripleMatch tripleMatch) {
            return this.count(this.base.find(tripleMatch));
        }

        ExtendedIterator count(ExtendedIterator extendedIterator) {
            return new WrappedIterator(this, extendedIterator){
                private final /* synthetic */ CountingGraph this$0;
                {
                    this.this$0 = countingGraph;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object next() {
                    try {
                        Object object = super.next();
                        return object;
                    }
                    finally {
                        ++this.this$0.counter;
                    }
                }
            };
        }

        int getCount() {
            return this.counter;
        }

        public String toString() {
            return this.base.toString();
        }
    }
}

