/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced.test;

import com.hp.hpl.jena.enhanced.AlreadyLinkedViewException;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.enhanced.UnsupportedPolymorphismException;
import com.hp.hpl.jena.enhanced.test.TestAllImpl;
import com.hp.hpl.jena.enhanced.test.TestModelImpl;
import com.hp.hpl.jena.enhanced.test.TestNode;
import com.hp.hpl.jena.enhanced.test.TestObjectImpl;
import com.hp.hpl.jena.enhanced.test.TestProperty;
import com.hp.hpl.jena.enhanced.test.TestPropertyImpl;
import com.hp.hpl.jena.enhanced.test.TestSubject;
import com.hp.hpl.jena.enhanced.test.TestSubjectImpl;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.GraphMem;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestPackage
extends GraphTestBase {
    private static final GraphPersonality split = new GraphPersonality();
    private static final GraphPersonality combo = new GraphPersonality();
    private static final GraphPersonality bitOfBoth = new GraphPersonality();
    private static final GraphPersonality broken = new GraphPersonality();
    static final int S = 1;
    static final int P = 2;
    static final int O = 3;
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestObject;
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestSubject;
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestPackage;
    static /* synthetic */ Class class$com$hp$hpl$jena$enhanced$test$TestPackage$Example;

    public TestPackage(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("Enhanced");
        testSuite.addTest((Test)new TestPackage("testSplitBasic"));
        testSuite.addTest((Test)new TestPackage("testComboBasic"));
        testSuite.addTest((Test)new TestPackage("testSplitFollow"));
        testSuite.addTest((Test)new TestPackage("testComboFollow"));
        testSuite.addTest((Test)new TestPackage("testSplitCache"));
        testSuite.addTest((Test)new TestPackage("testComboCache"));
        testSuite.addTest((Test)new TestPackage("testBitOfBothBasic"));
        testSuite.addTest((Test)new TestPackage("testBitOfBothFollow"));
        testSuite.addTest((Test)new TestPackage("testBitOfBothCache"));
        testSuite.addTest((Test)new TestPackage("testBitOfBothSurprise"));
        testSuite.addTest((Test)new TestPackage("testBrokenBasic"));
        testSuite.addTest((Test)new TestPackage("testSimple"));
        testSuite.addTest((Test)new TestSuite(class$com$hp$hpl$jena$enhanced$test$TestPackage == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage")) : class$com$hp$hpl$jena$enhanced$test$TestPackage));
        return testSuite;
    }

    private static void miniAsSupports(String string, TestNode testNode, Class clazz, boolean bl) {
        TestPackage.assertTrue((String)(string + ":sanity"), (boolean)(testNode instanceof Polymorphic));
        TestNode testNode2 = (TestNode)((Object)((EnhNode)((Object)testNode)).viewAs(clazz));
        TestNode testNode3 = (TestNode)((Object)((EnhNode)((Object)testNode)).viewAs(clazz));
        TestPackage.assertTrue((String)(string + ":idempotency"), (testNode2 == testNode3 ? 1 : 0) != 0);
        TestPackage.assertEquals((String)(string + ":support"), (boolean)bl, (boolean)((EnhNode)((Object)testNode2)).supports(clazz));
    }

    private static void oneNodeAsSupports(String string, TestNode testNode, boolean[] blArray) {
        TestPackage.miniAsSupports(string + "/TestSubject", testNode, class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, blArray[0]);
        TestPackage.miniAsSupports(string + "/TestProperty", testNode, class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, blArray[1]);
        TestPackage.miniAsSupports(string + "/TestObject", testNode, class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, blArray[2]);
    }

    private static void manyNodeAsSupports(String string, TestNode[] testNodeArray, boolean[][] blArray) {
        for (int i = 0; i < testNodeArray.length; ++i) {
            TestPackage.oneNodeAsSupports(string + "[" + i + "]", testNodeArray[i], blArray[i]);
        }
    }

    private static void basic(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        TestPackage.graphAdd(graphMem, "x R y;");
        TestNode[] testNodeArray = new TestNode[]{testModelImpl.aSubject(), testModelImpl.aProperty(), testModelImpl.anObject()};
        TestPackage.manyNodeAsSupports(string + "(a)", testNodeArray, new boolean[][]{{true, false, false}, {false, true, false}, {false, false, true}});
        TestPackage.graphAdd(graphMem, "y R x;");
        TestPackage.manyNodeAsSupports(string + "(b)", testNodeArray, new boolean[][]{{true, false, true}, {false, true, false}, {true, false, true}});
        graphMem.delete(TestPackage.triple("x R y"));
        TestPackage.manyNodeAsSupports(string + "(c)", testNodeArray, new boolean[][]{{false, false, true}, {false, true, false}, {true, false, false}});
    }

    private void canImplement(String string, TestNode testNode, int n, boolean bl) {
        try {
            switch (n) {
                case 1: {
                    testNode.asSubject().aProperty();
                    break;
                }
                case 2: {
                    testNode.asProperty().anObject();
                    break;
                }
                case 3: {
                    testNode.asObject().aSubject();
                }
            }
            TestPackage.assertTrue((String)"IllegalStateException expected.", (boolean)bl);
        }
        catch (IllegalStateException illegalStateException) {
            TestPackage.assertFalse((String)"IllegalStateException at the wrong time.", (boolean)bl);
        }
    }

    private void canImplement(String string, TestNode testNode, boolean[] blArray) {
        this.canImplement(string + "/TestSubject", testNode, 1, blArray[0]);
        this.canImplement(string + "/TestProperty", testNode, 2, blArray[1]);
        this.canImplement(string + "/TestObject", testNode, 3, blArray[2]);
    }

    private void canImplement(String string, TestNode[] testNodeArray, boolean[][] blArray) {
        for (int i = 0; i < testNodeArray.length; ++i) {
            this.canImplement(string + "[" + i + "]", testNodeArray[i], blArray[i]);
        }
    }

    private void follow(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        TestPackage.graphAdd(graphMem, "a b c;");
        TestNode[] testNodeArray = new TestNode[]{testModelImpl.aSubject(), testModelImpl.aProperty(), testModelImpl.anObject()};
        this.canImplement(string + "(a)", testNodeArray, new boolean[][]{{true, false, false}, {false, true, false}, {false, false, true}});
        TestPackage.graphAdd(graphMem, "b a c;");
        this.canImplement(string + "(b)", testNodeArray, new boolean[][]{{true, true, false}, {true, true, false}, {false, false, true}});
        graphMem.delete(TestPackage.triple("a b c"));
        this.canImplement(string + "(c)", testNodeArray, new boolean[][]{{false, true, false}, {true, false, false}, {false, false, true}});
        this.canImplement(string + "(c)", new TestNode[]{testNodeArray[1].asSubject().aProperty(), testNodeArray[2].asObject().aSubject(), testNodeArray[0].asProperty().anObject()}, new boolean[][]{{false, true, false}, {true, false, false}, {false, false, true}});
        TestPackage.assertTrue((String)"Model cache test", (testNodeArray[0].asProperty().anObject() == testNodeArray[2] ? 1 : 0) != 0);
    }

    private void cache(String string, Personality personality) {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, personality);
        TestPackage.graphAdd(graphMem, "a b a;");
        TestPackage.assertTrue((String)"Caching is on", (testModelImpl.aSubject().asObject() == testModelImpl.anObject() ? 1 : 0) != 0);
        testModelImpl.getNodeCacheControl().setEnabled(false);
        TestPackage.assertFalse((String)"Caching is off", (testModelImpl.aSubject() == testModelImpl.anObject() ? 1 : 0) != 0);
    }

    public static void testSplitBasic() {
        TestPackage.basic("Split: ", split);
    }

    public static void testComboBasic() {
        TestPackage.basic("Combo: ", combo);
    }

    public void testSplitFollow() {
        this.follow("Split: ", split);
    }

    public void testComboFollow() {
        this.follow("Combo: ", combo);
    }

    public void testSplitCache() {
        this.cache("Split: ", split);
    }

    public void testComboCache() {
        this.cache("Combo: ", combo);
    }

    public static void testBitOfBothBasic() {
        TestPackage.basic("bob: ", bitOfBoth);
    }

    public void testBitOfBothFollow() {
        this.follow("bob: ", bitOfBoth);
    }

    public void testBitOfBothCache() {
        this.cache("bob: ", bitOfBoth);
    }

    public static void testBitOfBothSurprise() {
        GraphMem graphMem = new GraphMem();
        TestModelImpl testModelImpl = new TestModelImpl(graphMem, bitOfBoth);
        TestPackage.graphAdd(graphMem, "a a a;");
        TestSubject testSubject = testModelImpl.aSubject();
        TestPackage.assertTrue((String)"BitOfBoth makes subjects using TestSubjectImpl", (boolean)(testSubject instanceof TestSubjectImpl));
        TestProperty testProperty = testSubject.aProperty();
        TestPackage.assertTrue((String)"BitOfBoth makes properties using TestAllImpl", (boolean)(testProperty instanceof TestAllImpl));
        TestPackage.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testProperty == testProperty.asSubject() ? 1 : 0) != 0);
        TestPackage.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testSubject != testProperty.asSubject() ? 1 : 0) != 0);
        TestPackage.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testSubject.asSubject() != testSubject.asSubject().asProperty().asSubject() ? 1 : 0) != 0);
    }

    public static void testBrokenBasic() {
        try {
            TestPackage.basic("Broken: ", broken);
            TestPackage.fail((String)"broken is a misconfigured personality, but it wasn't detected.");
        }
        catch (PersonalityConfigException personalityConfigException) {
            // empty catch block
        }
    }

    public void testSimple() {
        GraphMem graphMem = new GraphMem();
        Personality personality = BuiltinPersonalities.model.copy().add(class$com$hp$hpl$jena$enhanced$test$TestPackage$Example == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage$Example = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage$Example")) : class$com$hp$hpl$jena$enhanced$test$TestPackage$Example, Example.factory);
        EnhGraph enhGraph = new EnhGraph(graphMem, personality);
        Node node = Node.createURI("spoo:bar");
        EnhNode enhNode = new EnhNode(Node.createURI("spoo:bar"), enhGraph);
        EnhNode enhNode2 = new EnhNode(Node.createAnon(), enhGraph);
        TestPackage.assertTrue((String)"URI node can be an Example", (boolean)enhNode.supports(class$com$hp$hpl$jena$enhanced$test$TestPackage$Example == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage$Example = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage$Example")) : class$com$hp$hpl$jena$enhanced$test$TestPackage$Example));
        TestPackage.assertFalse((String)"Blank node cannot be an Example", (boolean)enhNode2.supports(class$com$hp$hpl$jena$enhanced$test$TestPackage$Example == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage$Example = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage$Example")) : class$com$hp$hpl$jena$enhanced$test$TestPackage$Example));
    }

    public void testAlreadyLinkedViewException() {
        GraphMem graphMem = new GraphMem();
        Personality personality = BuiltinPersonalities.model.copy().add(class$com$hp$hpl$jena$enhanced$test$TestPackage$Example == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage$Example = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage$Example")) : class$com$hp$hpl$jena$enhanced$test$TestPackage$Example, Example.factory);
        EnhGraph enhGraph = new EnhGraph(graphMem, personality);
        Node node = Node.create("spoo:bar");
        EnhNode enhNode = new EnhNode(node, enhGraph);
        enhNode.viewAs(class$com$hp$hpl$jena$enhanced$test$TestPackage$Example == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage$Example = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage$Example")) : class$com$hp$hpl$jena$enhanced$test$TestPackage$Example);
        try {
            enhNode.addView(enhNode);
            TestPackage.fail((String)"should raise an AlreadyLinkedViewException ");
        }
        catch (AlreadyLinkedViewException alreadyLinkedViewException) {
            // empty catch block
        }
    }

    public void testNullPointerTrap() {
        EnhGraph enhGraph = new EnhGraph(new GraphMem(), BuiltinPersonalities.model);
        Node node = Node.create("eh:something");
        EnhNode enhNode = new EnhNode(node, enhGraph);
        try {
            enhNode.as(class$com$hp$hpl$jena$enhanced$test$TestPackage == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage")) : class$com$hp$hpl$jena$enhanced$test$TestPackage);
            TestPackage.fail((String)"oops");
        }
        catch (UnsupportedPolymorphismException unsupportedPolymorphismException) {
            TestPackage.assertTrue((String)"exception should have cuplprit graph", (enhGraph == unsupportedPolymorphismException.getBadGraph() ? 1 : 0) != 0);
            TestPackage.assertTrue((String)"exception should have culprit class", ((class$com$hp$hpl$jena$enhanced$test$TestPackage == null ? (class$com$hp$hpl$jena$enhanced$test$TestPackage = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestPackage")) : class$com$hp$hpl$jena$enhanced$test$TestPackage) == unsupportedPolymorphismException.getBadClass() ? 1 : 0) != 0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        split.add(class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, TestObjectImpl.factory);
        split.add(class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, TestSubjectImpl.factory);
        split.add(class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, TestPropertyImpl.factory);
        combo.add(class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, TestAllImpl.factory);
        combo.add(class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, TestAllImpl.factory);
        combo.add(class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, TestAllImpl.factory);
        bitOfBoth.add(class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, TestObjectImpl.factory);
        bitOfBoth.add(class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, TestSubjectImpl.factory);
        bitOfBoth.add(class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, TestAllImpl.factory);
        broken.add(class$com$hp$hpl$jena$enhanced$test$TestObject == null ? (class$com$hp$hpl$jena$enhanced$test$TestObject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestObject")) : class$com$hp$hpl$jena$enhanced$test$TestObject, TestObjectImpl.factory);
        broken.add(class$com$hp$hpl$jena$enhanced$test$TestSubject == null ? (class$com$hp$hpl$jena$enhanced$test$TestSubject = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestSubject")) : class$com$hp$hpl$jena$enhanced$test$TestSubject, TestSubjectImpl.factory);
        broken.add(class$com$hp$hpl$jena$enhanced$test$TestProperty == null ? (class$com$hp$hpl$jena$enhanced$test$TestProperty = TestPackage.class$("com.hp.hpl.jena.enhanced.test.TestProperty")) : class$com$hp$hpl$jena$enhanced$test$TestProperty, TestObjectImpl.factory);
    }

    static class AnotherExample {
        static final Implementation factory = new Implementation(){

            public EnhNode wrap(Node node, EnhGraph enhGraph) {
                return new EnhNode(node, enhGraph);
            }

            public boolean canWrap(Node node, EnhGraph enhGraph) {
                return node.isURI();
            }
        };

        AnotherExample() {
        }
    }

    static class Example {
        static final Implementation factory = new Implementation(){

            public EnhNode wrap(Node node, EnhGraph enhGraph) {
                return new EnhNode(node, enhGraph);
            }

            public boolean canWrap(Node node, EnhGraph enhGraph) {
                return node.isURI();
            }
        };

        Example() {
        }
    }
}

