/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDBigNumberType;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.DecimalDV;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;

public class XSDGenericType
extends XSDDatatype {
    public XSDGenericType(XSSimpleType xSSimpleType, String string) {
        super(xSSimpleType, string);
    }

    public Object parse(String string) throws DatatypeFormatException {
        Object object = super.parse(string);
        if (object instanceof String || object instanceof Number) {
            return object;
        }
        XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)this.typeDeclaration;
        if (xSSimpleTypeDecl.getIsNumeric()) {
            return this.convertNumeric(object);
        }
        if (xSSimpleTypeDecl.getVariety() == 3) {
            try {
                return this.convertNumeric(object);
            }
            catch (ClassCastException classCastException) {
                return object;
            }
        }
        return object;
    }

    private Object convertNumeric(Object object) {
        if (object instanceof Number) {
            return object;
        }
        DecimalDV decimalDV = XSDBigNumberType.decimalDV;
        if (decimalDV.getFractionDigits(object) > 1) {
            return new BigDecimal(object.toString());
        }
        int n = decimalDV.getTotalDigits(object);
        if (n > 18) {
            return new BigInteger(object.toString());
        }
        if (n > 9) {
            return new Long(object.toString());
        }
        return new Integer(object.toString());
    }
}

