/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 24 17:58:51 2001 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util.lisp;

import junit.framework.*;

/**
 * Lisp data structures tests that don't assume very much works.
 */
public class BasicLispTest extends TestCase {

    public BasicLispTest(String name) {
	super(name);
    }

    public void testNil() {
	assertTrue(Lisp.NIL instanceof Null);
	assertTrue(Lisp.list() == Lisp.NIL);
	assertTrue(Lisp.list().length() == 0);
    }

    public void testCons() {
	Cons c = new Cons("a", new Cons("b", Lisp.NIL));
	assertTrue(c instanceof Cons);
	assertTrue(c.car() == "a");
	assertTrue(c.cdr().car() == "b");
	assertTrue(c.cdr().cdr() == Lisp.NIL);
    }

    public void testList() {
	Cons c = (Cons)Lisp.list("a", "b");
	assertTrue(c instanceof Cons);
	assertTrue(c.car() == "a");
	assertTrue(c.cdr().car() == "b");
	assertTrue(c.cdr().cdr() == Lisp.NIL);
    }

    public void testEquals() {
	assertEquals(new Cons("a", new Cons("b", Lisp.NIL)),
		     Lisp.list("a", "b"));
    }

}


