/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Mar 25 07:02:44 2005 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util.lisp;

import junit.framework.*;
import ix.util.Parameters;

/**
 * Test suite that includes all tests for the ix.util.lisp package.
 */
public class AllTests {

    public static void main(String[] argv) {
	Parameters.processCommandLineArguments(argv);
	junit.textui.TestRunner.run(suite());
    }

    public static Test suite () {
	TestSuite suite = new TestSuite("ix.util.lisp tests");

	suite.addTest(new TestSuite(BasicLispTest.class));
	suite.addTest(new TestSuite(SymbolTest.class));
	suite.addTest(new TestSuite(LispReadTest.class));

	// We now assume the Lisp reader works.

	suite.addTest(new TestSuite(LListTest.class));
	suite.addTest(new TestSuite(LListListIteratorTest.class));

	suite.addTest(new TestSuite(LListCollectorTest.class));
	suite.addTest(new TestSuite(LListCollectorListIteratorTest.class));

	suite.addTest(new TestSuite(LispInterpreterTest.class));

	return suite;
    }

}
