/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 27 23:22:03 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import junit.framework.*;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Simple context-related test cases for ContextGensym.Generators.
 */
public class ContextGensymContextTest extends TestCase {

    public ContextGensymContextTest(String name) {
	super(name);
    }

    protected void setUp() {
	Context.clearContexts();
    }

    protected void tearDown() {
	Context.clearContexts();
    }

    public void testInThreeContexts() {
	ContextGensym.Generator gen = new ContextGensym.Generator();
	ContextHashMap colour = new ContextHashMap();
	// Base context: a child of the root context.
	Context baseContext = Context.pushContext();
	// In base.
	assertEquals("apple-0", gen.nextString("apple"));
	// c1, a child of the base context
	Context c1 = Context.pushContext();
	// In c1.
	assertEquals("fruit-0", gen.nextString("fruit"));
	assertEquals("apple-1", gen.nextString("apple"));
	assertEquals("pie-0", gen.nextString("pie"));
	assertEquals("pie-1", gen.nextString("pie"));
	assertEquals("apple-2", gen.nextString("apple"));
	// Back to base context; check
	Context.popContext();
	assertSame(baseContext, Context.getContext());
	// c2, a different child of the base
	Context c2 = Context.pushContext();
	// In c2, we should get the same results as in c1.
	assertEquals("fruit-0", gen.nextString("fruit"));
	assertEquals("apple-1", gen.nextString("apple"));
	assertEquals("pie-0", gen.nextString("pie"));
	assertEquals("pie-1", gen.nextString("pie"));
	assertEquals("apple-2", gen.nextString("apple"));
	// Back to base
	Context.popContext();
	assertSame(baseContext, Context.getContext());
	// Changing anything in a context that has children is
	// very questionable, so we won't.
    }

}
