/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Apr 23 16:40:51 2001 by Jeff Dalton
 * Copyright: (c) 1998, 2001, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import junit.framework.*;

/** Seq.java test cases */

public class SeqTest extends TestCase {

    public SeqTest(String name) {
	super(name);
    }

    public void testVectorFromStringTokenizer() {

	assertTrue(
	     expectedVectorContents
	         (Seq.toVector(new StringTokenizer("a/b/c", "/")),
		  new String[] {"a", "b", "c"}));

    }

    public void testFilteringOut_A() {

	assertTrue(
	     expectedElements
	        (Seq.filter
		   (Seq.elements(new String[] {"a","b","a","a","c","d","a"}),
		    new Predicate1() {
			public boolean trueOf(Object s) {
			    return !((String)s).equals("a");
			}
		    }),
		 new String[] {"b","c","d"}));

    }

    static boolean expectedVectorContents(Vector v, Object[] a) {
	if (v.size() != a.length)
	    return false;
	else
	    for (int i = 0; i < a.length; i++)
		if (!v.elementAt(i).equals(a[i]))
		    return false;
	return true;
    }

    static boolean expectedElements(Enumeration e, Object[] a) {
	return expectedVectorContents(Seq.toVector(e), a);
    }

}
