/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Sep 22 17:36:23 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.util;

import junit.framework.*;

import java.util.*;

/** ISODateFormat test cases */

public class ISODateFormatTest extends TestCase {

    ISODateFormat format = new ISODateFormat();

    public ISODateFormatTest(String name) {
	super(name);
    }

    public void testReconversion() {

	// Try the "epoch": January 1, 1970, 00:00:00 GMT.
	check(new Date(0));

	// Try Feb 29, 1960 at 4:18 pm
	check(new GregorianCalendar(1960, 2, 29, 16, 18, 0).getTime());

	// Try current date and time without the milliseconds
	Date now = new Date();
	long time = now.getTime();
	Date near = new Date(time - (time % 1000));
	check(near);
    }

    protected void check(Date date) {
	assertEquals(date, format.parseDateTime(format.formatDateTime(date)));
    }

}
