/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Aug 19 00:47:52 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import junit.framework.*;

import ix.util.lisp.*;

/**
 * Test cases for full transitive-closures.
 */
public class FullTransitiveClosureTest extends AbstractTransitiveClosureTest {

    public FullTransitiveClosureTest(String name) {
	super(name);
    }

    protected TransitiveClosure makeTransitiveClosure(DirectedGraph g) {
	return new FullTransitiveClosure(g);
    }

    public void testTransitiveClosureWithCycle1() {
	// This test was copied from O-Plan.  It drove a bug in an
        // early version of tclosure when run in Lucid 4.1, but that
	// was a different algorithm.  This time -- as compared to
	// the test we inherit -- we follow the O-Plan text exactly
	// and have (d (e d)), which the ix.util.DAGTransitiveClosure
	// algorithm wouldn't accept because it's a cycle.
	LList alist = readGraphLList
	    ("((e (i)) (a (b c)) (b (d e f)) (d (e d)) (i (j)) (k ()))");
	Map m = alist.alistToMap(new StableHashMap());
	DirectedGraph g = Graphs.makeDirectedGraph(m);
	TransitiveClosure tc = makeTransitiveClosure(g);
	checkGraph
	    (readGraphLList
	       ("((a (b c f e d i j))" +
                " (b (f e d i j))" +
		" (c ())" +
                " (d (d e i j))" +
                " (e (i j))" +
		" (f ())" +	// no g or h for some reason
                " (i (j))" +
		" (j ())" +
		" (k ()))"),
	     tc);
    }

    public void testTransitiveClosureWithCycle2() {
	// This test was also copied from O-Plan.  it's the same as
	// the previous test but has the keys in the order that
	// drove a bug when the test was run in Lucid 4.1.  To get
	// exactly the same test as in Lucid 4.1, we have to control
        // the order of the keys by putting them in the desired
	// order in the initial alist and by using a StableHashMap
	// to make the DirectedGraph.  The order we want is:
	// (i k b d a e).
	LList alist = readGraphLList
	    ("((i (j)) (k ()) (b (d e f)) (d (e d)) (a (b c)) (e (i)))");
	Map m = alist.alistToMap(new StableHashMap());
	DirectedGraph g = Graphs.makeDirectedGraph(m);
	TransitiveClosure tc = makeTransitiveClosure(g);
	checkGraph
	    (readGraphLList
	       ("((a (b c f e d i j))" +
                " (b (f e d i j))" +
		" (c ())" +
                " (d (d e i j))" +
                " (e (i j))" +
		" (f ())" +	// no g or h for some reason
                " (i (j))" +
		" (j ())" +
		" (k ()))"),
	     tc);
    }

}
