/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Feb 22 19:34:59 2004 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import junit.framework.*;

import ix.util.lisp.*;

/**
 * Collection test cases.
 */
public abstract class AbstractModifiableListTest
    extends AbstractListTest {

    public AbstractModifiableListTest(String name) {
	super(name);
    }

    public void testFirstElementRemoval() {
	List abc = makeList(Lisp.list(STR_A, STR_B, STR_C));
	assertTrue(abc.remove(STR_A));
	assertTrue(haveSameElements(Lisp.list(STR_B, STR_C), abc));
	assertTrue(abc.remove(STR_B));
	assertTrue(haveSameElements(Lisp.list(STR_C), abc));
	assertTrue(abc.remove(STR_C));
	assertTrue(abc.isEmpty());
    }

    public void testLastElementRemoval() {
	List abc = makeList(Lisp.list(STR_A, STR_B, STR_C));
	assertTrue(abc.remove(STR_C));
	assertTrue(haveSameElements(Lisp.list(STR_A, STR_B), abc));
	assertTrue(abc.remove(STR_B));
	assertTrue(haveSameElements(Lisp.list(STR_A), abc));
	assertTrue(abc.remove(STR_A));
	assertTrue(abc.isEmpty());
    }

    public void testMiddleElementRemoval() {
	List abc = makeList(Lisp.list(STR_A, STR_B, STR_C));
	assertTrue(abc.remove(STR_B));
	assertTrue(haveSameElements(Lisp.list(STR_A, STR_C), abc));
    }

    public void testNonElementRemoval() {
	List abc = makeList(Lisp.list(STR_A, STR_B, STR_C));
	assertFalse(abc.remove("not there"));
	assertTrue(haveSameElements(Lisp.list(STR_A, STR_B, STR_C), abc));
    }

    public static boolean haveSameElements(List a, List b) {
	Iterator ai = a.iterator(), bi = b.iterator();
	while (ai.hasNext() && bi.hasNext()) {
	    if (!ai.next().equals(bi.next()))
		return false;
	}
	if (ai.hasNext() || bi.hasNext())
	    return false;
	else
	    return true;
    }

}
