/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jan 22 22:04:19 2004 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;
import java.io.*;

import junit.framework.*;

import ix.util.lisp.*;

/**
 * Collection test cases.  Does not assume that empty collections
 * can be modified.  Also must work for both Lists and Sets.
 */
public abstract class AbstractCollectionTest extends TestCase 
       implements UsefulTestObjects {

    public AbstractCollectionTest(String name) {
	super(name);
    }

    protected abstract Collection makeEmptyCollection();

    protected Collection makeCollection(Collection source) {
	// Because the empty LList isn't modifiable, we can't use
	// the inherited method which makes an empty collection
	// and then calls its addAll method.
	Collection c = makeEmptyCollection();
	c.addAll(source);
	return c;
    }

    public void testEmptyCollection() {
	Collection c = makeEmptyCollection();
	assertTrue("should be empty", c.isEmpty());
	// Add more assertions?
    }

    public void testOneElementCollection() {
	Collection c = makeCollection(Lisp.list("Apple"));
	assertEquals(1, c.size());
	assertTrue(c.contains("Apple"));
    }

    public void testEmptySerialization() {
	serializationTest(makeEmptyCollection());
    }

    public void testOneElementSerialization() {
	// Need a nicer way of building this /\/
	serializationTest(makeCollection(Lisp.list("Apple")));
    }

    public void testTwoElementSerizlization() {
	// Need a nicer way of building this /\/
	serializationTest(makeCollection
			  (Lisp.list("Apple", "Pie")));
    }

    public void serializationTest(Collection c) {
	if (c instanceof Serializable) {
	    try {
		Collection new_c = (Collection)TestUtil.serializeAndBack(c);

		assertSame("class", c.getClass(), new_c.getClass());
		assertEquals("size", c.size(), new_c.size());
		// Remember that the collection might not be ordered.
		assertTrue("old contains new", c.containsAll(new_c));
		assertTrue("new contains old", new_c.containsAll(c));
	    }
	    catch(Exception e) {
		Debug.noteException(e);	// JUnit way to to this?? /\/
		fail("Exception " + e);
	    }
	}
    }

}
