/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Feb 17 01:22:00 2006 by Jeff Dalton
 * Copyright: (c) 2001 - 2006, AIAI, University of Edinburgh
 */

package ix;

import junit.framework.*;
import ix.util.Parameters;

/**
 * Test suite that inculudes all I-X tests.
 */
public class AllTests {

    public static void main(String[] argv) {
	Parameters.processCommandLineArguments(argv);
	junit.textui.TestRunner.run(suite());
    }

    public static Test suite () {
	TestSuite suite = new TestSuite("I-X tests");

	// Subpackages
	if (Parameters.getBoolean("recursive", true)) {
	    suite.addTest(ix.util.AllTests.suite());
//	    suite.addTest(ix.iface.AllTests.suite());
	    suite.addTest(ix.iplan.AllTests.suite());
	    suite.addTest(ix.iscript.AllTests.suite());
	}

	return suite;
    }

}
