(refinement wsp-setup (web-service-problem)
  (constraints
    (world-state condition (in_hospital downed_pilot_1) = true)))

(refinement hospital_lookup (hospital_lookup to ?hospitals)
  (variables ?hospitals)
  (constraints
    (world-state effect (type ?hospitals) = hospital_list))
  (annotations
    (output-objects = ((?hospitals hospital_list)))))

(refinement sar_lookup (sar_lookup ?hospital to ?sar_resources)
  (variables ?hospital ?sar_resources)
  (constraints
    (world-state condition (type ?hospital) = hospital)
    (world-state effect (type ?sar_resources) = sar_resource_list))
  (annotations
    (output-objects = ((?sar_resources sar_resource_list)))))

(refinement hospital_selection (hospital_selection ?hospitals to
                                   ?hospital)
  (variables ?hospitals ?hospital)
  (constraints
    (world-state condition (type ?hospitals) = hospital_list)
    (world-state effect (type ?hospital) = hospital))
  (annotations
    (output-objects = ((?hospital hospital)))))

(refinement sar_resource_selection (sar_resource_selection
                                    ?sar_resources to ?sar_resource)
  (variables ?sar_resources ?sar_resource)
  (constraints
    (world-state condition (type ?sar_resources) = sar_resource_list)
    (world-state effect (type ?sar_resource) = sar_resource))
  (annotations
    (output-objects = ((?sar_resource sar_resource)))))

(refinement hospital_notifier (hospital_notifier ?hospital to)
  (variables ?hospital)
  (constraints
    (world-state condition (type ?hospital) = hospital)
    (world-state effect (notified ?hospital) = true)))

(refinement resource_notifier (resource_notifier ?resource to)
  (variables ?resource)
  (constraints
    (world-state condition (type ?resource) = sar_resource)
    (world-state effect (notified ?resource) = true)))

(refinement rescue_controller (rescue_controller ?hospital
                                  ?sar_resource ?pilot to)
  (variables ?hospital ?sar_resource ?pilot)
  (constraints
    (world-state condition (type ?hospital) = hospital)
    (world-state condition (type ?sar_resource) = sar_resource)
    (world-state condition (type ?pilot) = pilot)
    (world-state condition (notified ?hospital) = true)
    (world-state condition (notified ?sar_resource) = true)
    (world-state effect (location ?pilot) = ?hospital)
    (world-state effect (in_hospital ?pilot) = true)))

