;;; trains-1.tf -- A simple transport domain.

;;; Author: Jeff Dalton

;;; This is closely based on the O-Plan trains-1 domain.

(annotations
  (compute-support-code = "test-domains/trains-1-support.lsp"))

;;; Tasks

(refinement example-1 (example-1)
  (nodes
    (1 (trip T1 (Boston Charleston Atlanta)))))

(refinement example-2 (example-2)
  (nodes
    (1 (trip T1 (Boston Charleston Atlanta)))
    (2 (trip T2 (Boston New_York)))))

;;; The visit-only-once rule means that some trips, or sequences
;;; of trips, are impossible, even if its not obvious that they
;;; have a visit-conflict; but it's a pain to find a simple
;;; example, because (unlike in the O-Plan version) the
;;; connect-directly refinement allows a repeat visit.

;;; Action refinements

(refinement fill-1-step-path (trip ?train ?path)
  (variables ?train ?path ?start ?rest-path ?next)
  (nodes
    (1 (visit ?train ?start))
    (2 (connect ?train ?start ?next)))
  (orderings
    (1 2))
  (constraints
    (compute ((lambda (p) (= (length p) 2)) ?path) = true)
    (compute (first ?path) = ?start)
    (compute (rest ?path) = ?rest-path)
    (compute (first ?rest-path) = ?next)))

(refinement fill-path (trip ?train ?path)
  (variables ?train ?path ?start ?rest-path ?next)
  (nodes
    (1 (visit ?train ?start))
    (2 (connect ?train ?start ?next))
    (3 (trip ?train ?rest-path)))
  (orderings
    (1 2 3))
  (constraints
    (compute ((lambda (p) (> (length p) 2)) ?path) = true)
    (compute (first ?path) = ?start)
    (compute (rest ?path) = ?rest-path)
    (compute (first ?rest-path) = ?next)))

(refinement visit (visit ?train ?place)
  (variables ?train ?place)
  (constraints
    (world-state effect (visited ?train ?place) = true)))

(refinement connect-directly (connect ?train ?from ?to)
  (variables ?train ?from ?to)
  (constraints
    (compute (is-directly-connected ?from ?to) = true)))

(refinement connect-in-two (connect ?train ?from ?to)
  (variables ?train ?from ?to ?via)
  (nodes
    (1 (visit ?train ?via))
    (2 (connect ?train ?via ?to)))
  (orderings
    (1 2))
  (constraints
    (compute (is-directly-connected ?from ?to) = false)
    (compute multiple-answer (connected-cities ?from) = ?via)
    (compute (already-visited ?train ?via) = false)
    (compute (is-directly-connected ?via ?to) = true)))

(refinement connect (connect ?train ?from ?to)
  (variables ?train ?from ?to ?via)
  (nodes
    (1 (visit ?train ?via))
    (2 (connect ?train ?via ?to)))
  (orderings
    (1 2))
  (constraints
    (compute (is-directly-connected ?from ?to) = false)
    (compute multiple-answer (connected-cities ?from) = ?via)
    (compute (already-visited ?train ?via) = false)
    (compute (is-directly-connected ?via ?to) = false)))

;;; End
