;;; Missionaries and cannibals
;;; Author: Jeff Dalton
;;; Updated: Thu Apr 28 23:45:42 2005 by Jeff Dalton

;;; This is based on the O-Plan domain mission-with-only-compute.tf

(annotations
  (compute-support-code = "test-domains/missionary-support.lsp"))

;;; Tasks

(refinement mc-problem (mc-problem)
  (nodes
    (1 (setup))
    (2 (finish)))
  (orderings
    (1 2)))

(refinement setup (setup)
  (constraints
    (world-state effect (state) = (left 3 3 0 0)))
  (annotations
    ;; Keep this refinement from being used to achieve a condition.
    (use-for-world-state-effects = :none)))

(refinement finish (finish)
  (constraints
    (world-state condition (state) = (right 0 0 3 3))))

;;; Moving people

;;; Movements differ only in the numbers moved.

;;; In this version, we push the cond to achieve down a level so
;;; that all of the constraints remaining at this level can be satisfied.
;;; This lets the planner compute everything that can be computed
;;; rather than leaving it all up in the air until the achieve
;;; cond can be satisfied.  Thus, progress can be made.

(refinement move-m-c (to-reach ?new-state)
  (variables ?new-state ?pre-state ?move)
  (nodes
    (1 (block ?new-state))
    (2 (move ?pre-state ?move)))
  (orderings (1 2))
  (constraints
    (world-state effect (state) = ?new-state)
    ; (compute (equal ?new-state (left 3 3 0 0)) = false)
    (compute multiple-answer (identity ((2 0) (0 2) (1 0) (0 1) (1 1)))
	     = ?move)
    (compute (apply next-state ?new-state ?move) = ?pre-state)
    (compute (is-state ?pre-state) = true)
    ;; We use already-tried with ?new-state here to ensure that
    ;; this condition is before the action that blocks ?new-state.
    ;; Testing ?pre-state gets us to a plan more quickly, though.
    (compute (already-tried ?new-state) = false)))

(refinement block (block ?new-state)
  (variables ?new-state)
  (constraints
    (world-state effect (tried ?new-state) = true)))

(refinement back (move ?pre-state ?move)
  (variables ?pre-state ?move)
  (constraints
    (world-state condition (state) = ?pre-state)))

;;; End
