;;; Author: Jeff Dalton
;;; Updated: Mon Feb 21 02:58:03 2005 by Jeff Dalton

;;; This domain provides test tasks on top of the domain as it's
;;; normally used.

;;; This should have:

;;; * 1 sof team for both support and recovery with no further
;;;   advice constraints.

;;; * 2 sof teams, support and recovery, with no further advice.

;;; * 1 sof team for both support and recovery forced by advice
;;;   to use a HALO drop to move the sof team from its base to
;;;   near the IP.  (That's a case that the bug in the .init
;;;   file stopped working.)

;;; * At least one that starts with generic rescue and is
;;;   told to use sof by advice.

;;; * rescue-sof-support-covert-recovery

;;; * rescue-sof-support-civilian-recovery, maybe further constrained
;;;   to civilian trucks or heli.

;;; * Something with a diversion.

;;; * Something with no SOF.

;;; One SOF team used for both support and recovery

(refinement test-1-sof-support-and-recovery (test-1-sof-support-and-recovery)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement
      rescue (rescue-1-team-sof-support-sof-recovery))))

;;; Two SOF teams, one for support and the other for recovery.

(refinement test-2-sof-support-and-recovery (test-2-sof-support-and-recovery)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement
      rescue (rescue-2-teams-sof-support-sof-recovery))))

;;; One SOF team for both support and recovery,
;;; and required to use a HALO drop.

(refinement test-1-sof-halo-from-base (test-1-sof-halo-from-base)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement
      rescue (rescue-1-team-sof-support-sof-recovery))
    (advice expansion-refinement
      move-from-base (from-base-by-halo-drop))))

;;; Bridge from generic to SOF support and recovery
 
(refinement test-generic-with-sof-support-and-recovery
	    (test-generic-with-sof-support-and-recovery)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement rescue (rescue-generic))
    (advice expansion-refinement support/1 (support-by-sof))
    (advice expansion-refinement recover/1 (recover-by-sof))))

;;; SOF support, covert recovery

(refinement test-sof-support-covert-recovery (test-sof-support-covert-recovery)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement
      rescue (rescue-sof-support-covert-recovery))))

;;; SOF support, civilian recovery

(refinement test-sof-support-civilian-recovery
            (test-sof-support-civilian-recovery)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement
      rescue (rescue-sof-support-civilian-recovery))))

;;; SOF recovery using civilian transport

(refinement test-sof-recovery-by-civilian-heli
	    (test-sof-recovery-by-civilian-heli)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement
      rescue (rescue-2-teams-sof-support-sof-recovery))
    (advice expansion-refinement
      recover/2 (recover-by-civilian-heli))))

(refinement test-sof-recovery-by-civilian-fixed-wing
	    (test-sof-recovery-by-civilian-fixed-wing)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement
      rescue (rescue-2-teams-sof-support-sof-recovery))
    (advice expansion-refinement
      recover/2 (recover-by-civilian-fixed-wing))))

;;; Unassisted recovery

(refinement test-unassisted-recovery (test-unassisted-recovery)
  (nodes (1 (rescue UNESCO-Visitors)))
  (constraints
    (advice expansion-refinement
      rescue (rescue-unassisted-recovery))))

(include "co-opr-recovery.lsp")

;;; End
