;;; The first test shows a serious limitation in the way we now
;;; handle achieving; the later tests are variations that allow
;;; a plan to be found.

;;; N.B. The duplicate filter is only in I-Plan, not the planning
;;; algorithm, and so will not be there when auto-testing.

(refinement test1 (test1)
  ;; No solution, because an achieve for 3 can't introduce a
  ;; node before 2, because 2 has to execute before 3 can be
  ;; considered.  [It should work in O-Plan though.]
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures)))
  (orderings
    (1 2 3)))

(refinement test2 (test2)
  ;; Only one solution, modulo duplicates, but I-Plan has to reject
  ;; 12 duplicate plans to discover there's not a second one.
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures)))
  ;; This time 3 still has to be after 1, but not 2.
  (orderings
    (1 2) (1 3)))

(refinement test3 (test3)
  ;; Only one solution, modulo duplicates, but I-Plan has to reject
  ;; 30 duplicate plans to discover there's not a second one.
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures)))
  ;; 3 can happen whenever it wants relative to 1 and 2.
  (orderings
    (1 2)))

(refinement test4 (test4)
  ;; Only one solution, modulo duplicates, but I-Plan has to reject
  ;; 12 duplicate plans to discover there's not a second one.
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures-after new)))
  ;; The orderings let 3 happen whenever it wants relative to 1 and 2,
  ;; but a constraint means that it has to execute after 2.
  (orderings
    (1 2)))

(refinement set-decoration (set-decoration ?value)
  (variables ?value)
  (constraints
    (world-state effect (decoration) = ?value))
  (annotations
    ;; Keep this refinement from being used to achieve a condition.
    (use-for-world-state-effects = :none)))

(refinement take-pictures (take-pictures)
  (constraints
    (world-state condition (have-pictures-of old) = true)
    (world-state condition (have-pictures-of new) = true)))

(refinement snap (snap ?what)
  (variables ?what)
  (constraints
    (world-state condition (decoration) = ?what)
    (world-state effect (have-pictures-of ?what) = true)))

(refinement take-pictures-after (take-pictures-after ?value)
  (variables ?value)
  (constraints
    (world-state condition (decoration) = ?value)
    (world-state condition (have-pictures-of old) = true)
    (world-state condition (have-pictures-of new) = true)))

;;; End
