;;; Tests chaining back by achieving with one variable to bind
;;; at each step.

;;; This creates only one actual Variable, so it's a pretty
;;; simple test.

(refinement test1 (test1)
  (variables ?something)
  (constraints
    (world-state condition (did-c ?something) = true)))

(refinement test2 (test2)
  ;; Goes back one step further than test1.
  (variables ?something)
  (constraints
    (world-state condition (did-d ?something) = true)))

(refinement do-a (do-a thing-a)
  (constraints
    (world-state effect (did-a thing-a) = true)))

(refinement do-b (do-b ?a)
  (variables ?a)
  (constraints
    (world-state condition (did-a ?a) = true)
    (world-state effect (did-b ?a) = true)))

(refinement do-c (do-c ?b)
  (variables ?b)
  (constraints
    (world-state condition (did-b ?b) = true)
    (world-state effect (did-c ?b) = true)))

(refinement do-d (do-d ?c)
  (variables ?c)
  (constraints
    (world-state condition (did-c ?c) = true)
    (world-state effect (did-d ?c) = true)))

;;; End
