/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Oct  5 22:38:02 2004 by Jeff Dalton
 * Copyright: (c) 2002, 2003, AIAI, University of Edinburgh
 */

package ix.util.xml;

import javax.swing.*;

import java.awt.Container;
import java.awt.Component;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.*;

import ix.icore.IXAgent;
import ix.iface.util.*;

import ix.util.*;
import ix.util.lisp.*;

/** 
 * A frame that contains an XML viewing panel.
 * 
 * @see XMLTreeViewPanel
 */
public class XMLTreeViewFrame extends XMLTreeEditFrame {

    public XMLTreeViewFrame(IXAgent agent, String title) {
	super(agent, title);

	// /\/: An XMLTreeEditPanel normally has buttons at the bottom,
	// but an XMLTreeViewPanel doesn't, and we're adding them in
	// the frame instead.
	getContentPane()
	    .add(makeButtonPanel(), BorderLayout.SOUTH);

	// We can be smaller than an edit from because we don't
	// have the templates.
	setSize(300, 400);
	validate();

    }

    public boolean isEditor() {
	return false;
    }

    protected JPanel makeButtonPanel() {
	JPanel panel = new JPanel();
	// Stick with default flowlayout for now.
	JButton cancelButton = new JButton("Cancel");
	ActionListener cancelListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		XMLTreeViewFrame.this.setVisible(false);
	    }
	};
	cancelButton.addActionListener
	    (CatchingActionListener.listener(cancelListener));
	panel.add(cancelButton);
	return panel;
    }

    protected XMLTreeEditPanel makeEditPanel() { // factory method
	return new XMLTreeViewPanel();
    }

    protected void showHelp() {
	if (helpFrame == null) {
	    helpFrame = new TreeHelpFrame("Tree View Help");
	    helpFrame.setText(makeHelpText());
	}
	helpFrame.setVisible(true);
    }
	
    protected String makeHelpText() {
	return Strings.joinLines(sharedHelp) + Strings.joinLines(viewHelp);
    }

    /** 
     * Help text appended to {@link XMLTreeEditFrame#sharedHelp}
     * in viewers.
     */
    protected String[] viewHelp = {
	"", "",
        "This frame is a viewer only, but if an editor frame",
	"is also visible, it is possible to copy subtrees from",
	"this frame (using the right mouse button) and paste",
	"them into the editor."
    };
	
}
