/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Jan 17 00:30:57 2004 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.xml;

import javax.swing.*;

import java.awt.Container;
import java.awt.BorderLayout;
import java.awt.event.*;

import java.util.*;

import org.jdom.Document;

import ix.icore.IXAgent;

import ix.itest.DestinationChoice;

import ix.iface.util.*;
import ix.util.*;
import ix.util.lisp.*;


class XMLTreeSendFrame extends SimpleToolFrame 
    implements ActionListener {

    DestinationChoice destinationChoice;

    RadioButtonBox formSelector = makeFormControl();

    XMLTreeEditFrame frame;

    XMLTreeSendFrame(XMLTreeEditFrame frame, String title) {
	super(title);
	this.frame = frame;
	setup();
    }

    /**
     * Tell this SendFrame which edit frame contains the object
     * to send.
     */
    void setEditFrame(XMLTreeEditFrame frame) {
	this.frame = frame;
    }

    protected void setup() {
	super.setup();
	setActionListener(this);

	JPanel content = new JPanel();
	content.setLayout(new BorderLayout());
	setContentPane(content);

	content.setBorder(BorderFactory.createTitledBorder("Send To"));
	contentPane = content;

	destinationChoice =
	    new DestinationChoice(frame.getAgent(), new String[] { "me" });

	contentPane.add(destinationChoice, BorderLayout.NORTH);

	contentPane.add(formSelector, BorderLayout.CENTER);

	JPanel buttons = makeButtonPanel(new String[] {
	    "Send",
	    "Cancel"
	});
	contentPane.add(buttons, BorderLayout.SOUTH);

	// setSize(300, 200);
	pack();
    }

    protected RadioButtonBox makeFormControl() {
	RadioButtonBox box = RadioButtonBox.createHorizontalBox();
	box.add(Box.createHorizontalGlue());

	box.add(new JRadioButton("Send XML"));
	box.add(new JRadioButton("Send Object", true));

	box.add(Box.createHorizontalGlue());
	return box;
    }

    public void actionPerformed(ActionEvent event) {
	String command = event.getActionCommand();
	if (command.equals("Cancel")) {
	    setVisible(false);
	}
	else if (command.equals("Send")) {
	    Send();
	    setVisible(false);
	}
	else
	    throw new ConsistencyException
		("Nothing to do for " + command);
    }

    protected void Send() {
	String dest = destinationChoice.getSelectedString();
	String form = formSelector.getSelection();
	if (form.equals("Send XML")) {
	    sendXML(dest, frame.getDocument());
	}
	else if (form.equals("Send Object")) {
	    sendObject(dest, frame.getObject());
	}
	else
	    throw new ConsistencyException
		("Invalid form for send: " + Strings.quote(form));
    }

    protected void sendObject(String dest, Object contents) {
	if (dest.equals("me"))
	    frame.getAgent().handleInput(new IPC.BasicInputMessage(contents));
	else
	    IPC.sendObject(dest, contents);
    }

    protected void sendXML(final String dest, Document doc) {
	if (dest.equals("me")) {
	    sendObject(dest, XML.objectFromDocument(doc));
	    return;
	}
	// Temporarily subvert XML translation.
	Debug.expect(!(XML.defaultTranslator()
		       instanceof SubversiveTranslator));
	final Object cookie = new Object();
	final SubversiveTranslator st = new SubversiveTranslator();
	st.setTranslation(cookie, doc);
	XML.withDefaultTranslator(st, new Runnable() {
	    public void run() {
		IPC.sendObject(dest, cookie);
	    }
	});
    }

    class SubversiveTranslator extends XMLTranslator {

	Map subversions = new HashMap();

	SubversiveTranslator() {
	    this(XML.defaultTranslator());
	}

	SubversiveTranslator(XMLTranslator base) {
	    // /\/: Copy over some things we happen to know we need,
	    // rather than doing a proper job of duplicating the base.
	    super(base.getClassSyntax());
	    this.omitImplAttributes = base.omitImplAttributes;
	}

	public String objectToXMLString(Object obj) {
	    Document doc = (Document)subversions.get(obj);
	    return documentToXMLString
		(doc != null ? doc : objectToDocument(obj));
	}

	void setTranslation(Object obj, Document doc) {
	    subversions.put(obj, doc);
	}

    }

}
