/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Sep 21 19:42:18 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.reflect;

import java.lang.reflect.*;
import java.util.*;

import ix.util.*;

/**
 * A view or description of a field.
 *
 * <p>N.B. The constructors are deliberately not public so that something
 * wanting a FieldDescr must go through a {@link ClassSyntax} object.
 */
public class FieldDescr {

    protected String name;		// Java name
    protected String externalName;
    protected Class type;
    ClassDescr typeDescr;
    Method getter;
    Method setter;

    FieldDescr(ClassSyntax syntax, String javaName, Class type) {
	this.name = javaName;
	this.externalName = syntax.externalNameForField(name);
	this.type = type;
	// this.typeDescr is filled-in later and may not be the
	// ClassDescr of type.  For example, it might be known
	// that a List is a list of Issues, and the typeDescr
	// would reflect that.
    }

    public String getName() {
	return name;
    }

    public String getExternalName() {
	return externalName;
    }

    public Class getType() {
	return type;
    }

    public ClassDescr getTypeDescr() {
	return typeDescr;
    }

    public Object getValue(Object obj)
	throws IllegalAccessException,
	       IllegalArgumentException,
	       InvocationTargetException {
	return getter.invoke(obj, new Object[0]);
    }

    public void setValue(Object obj, Object newVal)
	throws IllegalAccessException,
	       IllegalArgumentException,
	       InvocationTargetException {
	setter.invoke(obj, new Object[] { newVal });
    }

    public String toString() {
	return "FieldDescr[" + type.getName() + " " + name + "]";
    }

}

// Issues:
// * getType() returns a Class, so that getTypeDescr() has to be
//   called to get the ClassDescr, but the ClassDescr get...Type()
//   methods such as getEltType() all return ClassDescrs.
