/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Apr 10 19:32:24 2004 by Jeff Dalton
 */

package ix.util.lisp;

import java.util.*;

/**
 * An implementation of Iterator for LLists.
 */
public class LListIterator implements Iterator {
    
    protected LList at = null;		// for the next next()

    public LListIterator(LList list) {
	this.at = list;
    }

    public LListIterator(LListIterator i) {
	this.at = i.at;
    }

    /**
     * Returns the tail of the list that corresponds to the iterator's
     * current position.  If the tail is not empty, its first element
     * is the object that would be returned by the next call to the
     * iterator's next() method.
     */
    public LList getTail() {
	return at;
    }

    public boolean hasNext() {
	return at != Lisp.NIL;
    }

    public Object next() {
	if (at != Lisp.NIL) {
	    Object elt = at.car();
	    at = at.cdr();
	    return elt;
	}
	else
	    throw new NoSuchElementException("at end of LList");
    }

    /**
     * @throws UnsupportedOperationException if called.
     */
    public void remove() {
	throw new UnsupportedOperationException("Cannot remove from an LList");
    }

}
