/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar  6 01:02:40 2003 by Jeff Dalton
 */

package ix.util.lisp;

import java.util.*;

import ix.util.*;

/**
 * A minimal HashMap-like mapping with == as the equality test.
 * This does not attempt to implement the Map interface.
 */
public class EqMap {

    // Objects considered the same by the equals method will map
    // to the same plist; there's then a linear search with ==
    // as the test.

    protected Map toPlist = new HashMap();

    public EqMap() {}

    public Object get(Object key) {
	LList plist = (LList)toPlist.get(key);
	if (plist == null)
	    return null;
	else
	    return plist.get(key);
    }

    public void put(Object key, Object value) {
	LList plist = (LList)toPlist.get(key);
	if (plist == null)
	    plist = Lisp.NIL;
	toPlist.put(key, plist.put(key, value));
    }

    public void clear() {
	toPlist.clear();
    }

}
