/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Nov  7 06:42:06 2004 by Jeff Dalton
 * Copyright: (c) 2002 - 2003, AIAI, University of Edinburgh
 */

package ix.util.ipc;

import java.util.*;

import ix.util.*;

/**
 * A communication strategy that is wrapped around another, "inner",
 * strategy.
 */
public class WrapperStrategy implements ParameterizedCommStrategy {

    IPC.CommunicationStrategy innerStrategy;

    public WrapperStrategy() {
    }

    public WrapperStrategy(IPC.CommunicationStrategy innerStrategy) {
	this.innerStrategy = innerStrategy;
    }

    public IPC.CommunicationStrategy apply(String[] args) {
	if (args.length != 1)
	    throw new IllegalArgumentException
		("Wrapper strategy expected 1 parameter but received " +
		 args.length + ": " + Arrays.asList(args));
	else {
	    innerStrategy = IPC.makeCommunicationStrategy(args[0]);
	    return this;
	}
    }

    public void sendObject(Object destination, Object contents) {
	Debug.expect(innerStrategy != null,
		     "No inner strategy has been given to ", this);
	innerStrategy.sendObject(destination, contents);
    }

    public void setupServer(Object destination,
			    IPC.MessageListener listener) {
	Debug.expect(innerStrategy != null,
		     "No inner strategy has been given to ", this);
	innerStrategy.setupServer(destination, listener);
    }

}
