/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Sep 27 16:13:54 2006 by Jeff Dalton
 * Copyright: (c) 2003, 2006, AIAI, University of Edinburgh
 */

package ix.util.ipc;

import java.util.*;

import ix.util.xml.*;
import ix.util.*;

/**
 * A wrapper strategy that describes the input and output as XML.
 */
public class TracingStrategy extends WrapperStrategy {

    XMLTranslator xmlt = XML.config().makeXMLTranslator();
    { xmlt.setOmitImplAttributes(false); }

    public TracingStrategy() {
	super();
    }

    public TracingStrategy(IPC.CommunicationStrategy innerStrategy) {
	super(innerStrategy);
    }

    public void sendObject(Object destination, Object contents) {
	traceSend(destination, contents);
	super.sendObject(destination, contents);
    }

    public void setupServer(Object destination,
			    final IPC.MessageListener innerListener) {
	innerStrategy.setupServer(destination, new IPC.MessageListener() {
	    public void messageReceived(IPC.InputMessage message) {
		traceReceive(message);
		innerListener.messageReceived(message);
	    }
	});
    }

    protected void traceSend(Object destination, Object contents) {
	Debug.noteln("Sending to", destination);
	Debug.noteln("Contents as XML:", xmlt.objectToXMLString(contents));
    }

    protected void traceReceive(IPC.InputMessage message) {
	Debug.noteln("Message received, as XML:",
		     xmlt.objectToXMLString(message.getContents()));
    }

}
