/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Sep 24 23:46:00 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.ipc;

import java.util.*;

import ix.icore.IXAgent;
import ix.icore.Sendable;
import ix.util.*;

public class SeparateStrategy extends WrapperStrategy {

    SeparateAgent separateAgent;

    public SeparateStrategy() {
	super();
    }

    public SeparateStrategy(IPC.CommunicationStrategy innerStrategy) {
	super(innerStrategy);
    }

    public void sendObject(Object destination, Object contents) {
	if (separateAgent == null)
	    throw new IPC.IPCException
		("Cannot send until registration is complete");
	if (contents instanceof Sendable) {
	    Sendable s = (Sendable)contents;
	    s.setSenderId(Name.valueOf(separateAgent.getAgentSymbolName()));
	}
        innerStrategy.sendObject(destination, contents);
    }

    public void setupServer(final Object destination,
			    final IPC.MessageListener listener) {
	separateAgent = new SeparateAgent(IXAgent.getAgent());
	separateAgent.runAsMainAgent(new Runnable() {
	    public void run() {
		innerStrategy.setupServer(destination, listener);
	    }
	});
    }

    class SeparateAgent extends IXAgent {

	IXAgent baseAgent;

	SeparateAgent(IXAgent baseAgent) {
	    super(false);
	    this.baseAgent = baseAgent;
	}

	public void addTool(ix.iface.util.ToolController tc) {
	    baseAgent.addTool(tc);
	}

	public Object ensureTool(String toolName) {
	    return baseAgent.ensureTool(toolName);
	}

	public void runAsMainAgent(Runnable r) {
	    IXAgent saved = thisAgent;
	    try {
		thisAgent = this;
		r.run();
	    }
	    finally {
		thisAgent = saved;
	    }
	}

    }

}
