/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Oct  2 18:08:02 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2004, 2006, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

import ix.util.*;

/**
 * An object that contains a single context-dependent value.
 */
public class TypedContextValue<T> extends ContextValue<T> {

    protected Class type;

    public TypedContextValue(Class type, T value) {
	this(Context.getContextHolder(), type, value);
    }

    public TypedContextValue(ContextHolder holder, Class type, T value) {
	super(holder, value);
	this.type = type;
    }

    public void set(T new_value) {
	if (type != null && new_value != null && !(type.isInstance(new_value)))
	    throw new ClassCastException
		("Attempt to set a ContextValue to an instance of " +
		 new_value.getClass().getName() +
		 " when the class must be " + type.getName());
	Context.setInContext(link, holder.getContext(), new_value);
    }

}
