/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jan 19 18:17:51 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * A context-holding strategy that associates context-holders with
 * threads.  The holder for a thread is initially null and so must
 * be explicitly set.  More than one thread may be given the same
 * context-holder.
 */
public class ThreadLocalHoldingStrategy extends ContextHoldingStrategy {

    WeakHashMap knownHolders = new WeakHashMap();

    ThreadLocal threadContextHolder;

    public ThreadLocalHoldingStrategy() {
	threadContextHolder = new ThreadLocal();
    }

    public ContextHolder getContextHolder() {
	return (ContextHolder)threadContextHolder.get();
    }

    public synchronized void setContextHolder(ContextHolder h) {
	knownHolders.put(h, null);
	threadContextHolder.set(h);
    }

    public synchronized void clearContexts() {
	for (Iterator i = knownHolders.entrySet().iterator(); i.hasNext();) {
	    ContextHolder h = (ContextHolder)i.next();
	    h.setContext(Context.rootContext);
	}
    }

}
