/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jan 19 18:17:58 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * A context-holding strategy that associates context-holders with
 * threads, with inheritance from the parent thread.  Although the
 * holder for a thread is inherited from the thread's parent, it
 * may be explicitly set to a different value.
 */
public class InheritableThreadLocalHoldingStrategy
       extends ThreadLocalHoldingStrategy {

    public InheritableThreadLocalHoldingStrategy() {
	threadContextHolder = new InheritableThreadLocal();
    }

}
