/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May  7 18:40:37 2001 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

import ix.util.Debug;

/**
 * An interface for objects that contain a Context that they provide
 * to other objects.  A single ContextHolder is typically shared by many
 * objects that contain context-layered fields so that they can all be
 * moved to a different context together.
 *
 * @see Context
 * @see ContextHoldingStrategy
 */
public interface ContextHolder {

    /**
     * Returns the context currently stored in the holder.
     */
    public Context getContext();

    /**
     * Changes the context currently stored in the holder.
     */
    public void setContext(Context c);

}
