/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Apr 24 14:50:24 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * An object that contains a single context-dependent boolean value.
 */
public class ContextBoolean {

    ContextHolder holder;
    ContextLink link;

    public ContextBoolean(boolean rootValue) {
	this(Context.getContextHolder(),
	     rootValue);
    }

    public ContextBoolean(ContextHolder holder, boolean rootValue) {
	this.holder = holder;
	this.link = new ContextLink(new Boolean(rootValue));
    }

    public boolean get() {
	return ((Boolean)Context.getInContext(link, holder.getContext()))
	            .booleanValue();
    }

    public boolean isTrue() {
	return ((Boolean)Context.getInContext(link, holder.getContext()))
	            .booleanValue();
    }

    public boolean isFalse() {
	return !((Boolean)Context.getInContext(link, holder.getContext()))
	             .booleanValue();
    }

    public void set(boolean new_value) {
	Context.setInContext(link,
			     holder.getContext(),
			     new Boolean(new_value));
    }

}
