/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Sep 22 00:46:21 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

import ix.icore.AbstractAnnotatedObject;
import ix.util.*;

/**
 * Provides context-dependent annotations.
 */
public abstract class ContextAnnotatedObject extends AbstractAnnotatedObject {

    private ContextHashMap __annMap = null; // not serialized? /\/

    public ContextAnnotatedObject() { }

    protected Map annMap() {
        return __annMap;
    }

    protected void makeAnnMap() {
        Debug.expect(annotations == null);
	Debug.expect(__annMap == null);
	__annMap = new ContextHashMap();
    }

    public void clearAnnotationsCompletely() {
	if (__annMap != null)
	    __annMap.clearCompletely();
    }

}
