/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jan 17 15:53:41 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

/**
 * Handles waiting for a condition to be made true by another thread.
 * ThreadConditions are Comparable so that threads waiting for more
 * than one condition can test them in a standard order.
 */
public class ThreadCondition implements Comparable {

    protected String name;
    protected boolean isTrue = false;
    protected int number;

    protected static int count = 0;
    {
	synchronized(ThreadCondition.class) {
	    number = count++;
	}
    }

    public ThreadCondition() { this("anonymous"); }

    public ThreadCondition(String name) {
	this.name = name;
    }

    public synchronized void setTrue() {
	isTrue = true;
	notifyAll();
    }

    public synchronized void setFalse() {
	isTrue = false;
    }

    public synchronized boolean isTrue() {
	return isTrue;
    }

    public synchronized void waitUntilTrue() {
	while (!isTrue) {
	    try { wait(); }
	    catch (InterruptedException e) {}
	}
    }

    /**
     * Wait with a timout.
     *
     * @param timeout time limit, in milliseconds
     */
    public synchronized void waitUntilTrue(long timeout) {
	if (!isTrue) {
	    try { wait(timeout); }
	    catch (InterruptedException e) {}
	}
    }

    public int compareTo(Object o) {
	if (o instanceof ThreadCondition)
	    return this.number - ((ThreadCondition)o).number;
	else
	    throw new ClassCastException
		("Cannot compare " + this + " to " + o);
    }

    public String toString() {
	return "ThreadCondition[" + number + " " + name + "]";
    }

}
