/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar  3 02:29:22 2005 by Jeff Dalton
 * Copyright: (c) 2003, 2005, AIAI, University of Edinburgh
 */

package ix.util;

/**
 * Procedure objects.
 */
public abstract class Proc {

    public void call() { lose(0); }
    public void call(Object a) { lose(1); }
    public void call(Object a, Object b) { lose(2); }
    public void call(Object a, Object b, Object c) { lose(3); }
    public void call(Object a, Object b, Object c, Object d) { lose(4); }
    public void call(Object a, Object b, Object c, Object d, Object e) {
	lose(5);
    }

    private void lose(int arity) {
	throw new UnsupportedOperationException
	    ("Called " + arity + "-argument call method by mistake.");
    }

}

// Issues:
// * Like this, or interfaces as for Function1, Function2, etc?
