/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Apr  4 15:47:08 2005 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util;

import java.io.Serializable;

/**
 * Wrapper for relatively short strings used as names. <p>
 *
 * Names should be created by calling <code>Name.valueOf(String)</code>.
 */
public class Name implements Comparable, Serializable, SemiPrimitive {

    protected String name;

    protected Name() { }

    protected Name(String name) {
	this.name = name;
    }

    public String toString() {
	return name;
    }

    public static Name valueOf(String name) {
	return new Name(name);
    }

    public static Name valueOf(Object obj) {
	// This method is very convenient but doesn't always
	// make sense.  /\/
	return valueOf(obj.toString());
    }

    public int hashCode() {
	return name.hashCode();		// ??? /\/
    }

    public boolean equals(Object a) {
	return (a instanceof Name) && ((Name)a).name.equals(name);
    }

    public int compareTo(Object o) {
	if (o instanceof Name)
	    return name.compareTo(((Name)o).name);
	else
	    throw new ClassCastException
		("Cannot compare name " + this + " to " + o);
    }

}

// Issues:
// * Perhaps should be called Id.  Problem is we may want Id for
//   use as an ID in XML.

