/* Author: Jeff Dalton
 * Updated: Mon Feb 17 20:09:52 2003 by Jeff Dalton
 * Copyright: (c) 2000, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

/**
 * A MultiHashMap is (by weak analogy with "multiset") a HashMap
 * that maps each key to a collection of values.  When the first
 * value is added for a given key, the collection that holds that
 * key's values is created by the <code>makeValueCollection</code>
 * method.  In this class, it creates a LinkedList, but that can
 * be changed by redefining the method in a subclass.
 */
public class MultiHashMap extends HashMap implements MultiMap {

    public MultiHashMap() {
	super();
    }

    /** Set the entire colletion of values associated with the key. */
    public Object put(Object key, Object value) {
	if (!(value == null || value instanceof Collection))
	    throw new IllegalArgumentException("Value must be a collection");
	return super.put(key, value);
    }

    public Object addValue(Object key, Object value) {
	Collection already = (Collection)get(key);
	if (already == null) {
	    already = makeValueCollection(value);
	    super.put(key, already);
	}
	else
	    already.add(value);
	return already;
    }

    public boolean removeValue(Object key, Object value) {
	Collection values = (Collection)get(key);
	if (values == null)
	    throw new IllegalArgumentException("No entry for key " + key);
	return values.remove(value);
    }

    public Collection makeValueCollection(Object firstItem) {
	Collection c = new LinkedList();
	c.add(firstItem);
	return c;
    }

}

// Issues:
// * Maybe should include a HashMap rather than extend, or maybe should
//   extend AbstractMap.
