/* File: Markable.java
 * Contains: An interface for markable objects
 * Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Created: March 1998
 * Updated: Fri Mar 27 02:47:40 1998 by Jeff Dalton
 * Copyright: (c) 1998, AIAI, University of Edinburgh
 */

package ix.util;

/**
 * An interface for markable objects.  For some algorithms, it is useful
 * to have objects that can record and test marks, to mark the objects 
 * as used, visited, etc.  This interface defines the required operations.
 *
 * @see Mark
 */

public interface Markable {

    void setMark(Mark m);

    boolean hasMark(Mark m);

}
