/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Oct 19 16:46:35 2006 by Jeff Dalton
 * Copyright: (c) 2005, 2006, AIAI, University of Edinburgh
 */

package ix.util;

/**
 * Very simple arithmetic with a pretend positive infinity.
 */
public final class Inf {

    private Inf() { }		// block instantiation

    public static final long INFINITY = Long.MAX_VALUE;

    public static boolean isLess(long i, long j) {
	return i < j;		// depends on infinity being Long.MAX_VALUE
    }

    public static long add(long i, long j) {
	return (i == INFINITY || j == INFINITY) ? INFINITY : i + j;
    }

    public static long diff(long i, long j) { // i - j
	if (i == INFINITY) return INFINITY;
	else if (j == INFINITY)
	    throw new IllegalArgumentException
		("Cannot subtract infinity from " + i);
	else return i - j;
    }

    public static String asString(long i) {
	return i == INFINITY ? "inf" : i + "";
    }

}
