/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Mar  9 15:59:29 2003 by Jeff Dalton
 * Copyright: (c) 2002, 2003 AIAI, University of Edinburgh
 */

package ix.util;

import ix.util.reflect.ClassSyntax;

/**
 * Copies Objects, recursively copying subobjects.
 */
public class DeepCopier extends ObjectCopier {

    public DeepCopier() {
	super();
    }

    public DeepCopier(ClassSyntax syntax) {
	super(syntax);
    }

    /**
     * Called on subobjects of the object being copied to determine
     * what object takes the subobject's place in the copy.  The method
     * in this class returns a copy of the object.
     */
    public Object mapElement(Object elt) {
	return copy(elt);
    }

}
