/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Oct 26 14:14:39 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import java.net.*;
import java.io.*;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

import javax.swing.*;

public class AgentLauncher {

    Map parameters = new HashMap();
    String agentClassName;
    String[] agent_argv = new String[]{};
    String jarPath;
    ClassLoader loader;

    public AgentLauncher() {
    }

    public static void main(String[] argv) throws Exception {
	AgentLauncher launcher = new AgentLauncher();
	try {
	    argv = launcher.getArgv(argv);
	    launcher.startAgent(argv);
	}
	catch (final Throwable t) {
	    t.printStackTrace(System.out);
	    SwingUtilities.invokeAndWait(new Runnable() {
		public void run() {
		    JOptionPane.showMessageDialog
			(null, t.toString(),
			 "Exception",
			 JOptionPane.ERROR_MESSAGE);
		}
	    });
	}
    }

    String[] getArgv(String[] argv) 
	     throws InterruptedException, InvocationTargetException {
	// System.out.println("Initial argv = " + Arrays.asList(argv));
	if (argv.length == 0) {
	    // Look for ix.jar in various places so we can put it and
	    // the "imports" dir on the initial jar-path that we offer
	    // to the user when no parameters were specified.
	    String ixDir = findIxDir();
	    final String defaultCommand =
		"-jar-path=" + makeDefaultJarPath(ixDir) + " ix.ip2.Ip2";
	    // ... /\/
	    // Ask the user for a command-line.
	    final String[] command = new String[]{""};
	    SwingUtilities.invokeAndWait(new Runnable() {
		public void run() {
		    command[0] =
			JOptionPane.showInputDialog
			    ("Command line", defaultCommand);
		}
	    });
	    if (command[0] == null || command[0].equals(""))
		System.exit(0);
	    List args = breakAt(" ", command[0]);
	    argv = (String[])args.toArray(new String[args.size()]);
	}
	return argv;
    }

    String findIxDir() {
	if (new File("ix.jar").exists())
	    return "";
	else if (new File("../../ix.jar").exists())
	    return "../../";
	else
	    return null;
    }

    String makeDefaultJarPath(String ixDir) {
	if (ixDir == null)
	    return "ix.jar:imports";
	else
	    return ixDir + "ix.jar" + ":" + ixDir + "imports";
    }

    public void startAgent(String[] argv) throws Exception {

	for (int i = 0; i < argv.length; i++) {
	    if (argv[i].startsWith("-")) {
		String arg = argv[i].substring(1); // remove the "-"
		List parts = breakAt("=", arg);
		String pname = (String)parts.get(0);
		String value = (String)parts.get(1);
		parameters.put(pname, value);
	    }
	    else {
		agentClassName = argv[i++];
		int agent_nargs = argv.length - i;
		agent_argv = new String[agent_nargs];
		for (int j = 0; i < argv.length; j++, i++) {
		    agent_argv[j] = argv[i];
		}
		break;
	    }
	}
	if (agentClassName == null)
	    throw new IllegalArgumentException
		("No agent class name was specified");
	System.out.println("Launcher parameters " + parameters);
	System.out.println("Agent class " + agentClassName);
	System.out.println("Agent args " + Arrays.asList(agent_argv));

	jarPath = (String)parameters.get("jar-path");
	loader = makeLoader(jarPath == null ? "" : jarPath);
	startAgent(agentClassName, agent_argv);

    }

    public void startAgent(String className, String[] argv) throws Exception {
	// System.out.println("Loading " + className + " using " + loader);
	Class c = loader.loadClass(className);
	// System.out.println(c + " class loader = " + c.getClassLoader());
	Class[] sig = new Class[] { argv.getClass() };
	Method m = c.getMethod("main", sig);
	m.invoke(null, new Object[] { argv });
    }

    URLClassLoader makeLoader(String jarPath)
	           throws MalformedURLException, FileNotFoundException {
	List dirs = breakAt(":", jarPath);
	List jars = new LinkedList();
	for (Iterator di = dirs.iterator(); di.hasNext();) {
	    String dirName = (String)di.next();
	    File dir = new File(dirName);
	    if (!dir.exists())
		throw new FileNotFoundException
		    ("Jar-path entry " + dirName + " does not exist.");
	    else if (dirName.endsWith(".jar"))
		jars.add(dir.toURL());
	    else {
		File[] files = dir.listFiles(new FileFilter() {
		    public boolean accept(File f) {
			return f.getName().endsWith(".jar");
		    }
		});
		if (files == null)
		    throw new IllegalArgumentException
			("Problem with jar-path entry " + dirName);
		else if (files.length == 0)
		    // There are no .jar files in the directory,
		    // so assume it contains .class files.
		    jars.add(dir.toURL());
		else {
		    for (int i = 0; i < files.length; i++) {
			jars.add(files[i].toURL());
		    }
		}
	    }
	}
	System.out.println("Jar-path " + jars);
	URL[] urls = (URL[])jars.toArray(new URL[jars.size()]);
	return new AgentClassLoader(urls);
    }

    static class AgentClassLoader extends URLClassLoader {

	AgentClassLoader(URL[] urls) {
	    super(urls);
	}
	
	public Class loadClass(String name) throws ClassNotFoundException {
	    return loadClass(name, false);
	}

	protected Class loadClass(String name, boolean resolve)
	          throws ClassNotFoundException {
	    // System.out.println("Trying class " + name);
	    if (name.startsWith("java.") || name.startsWith("javax.")
		  || name.startsWith("sun."))
		return super.loadClass(name, resolve);
	    // System.out.println("Loading class " + name);
	    Class c = findLoadedClass(name);
	    if (c == null)
		c = findClass(name);
	    if (resolve)
		resolveClass(c);
	    return c;
	}

    }

    private static List breakAt(String separator, String s) {
	List result = new LinkedList();
	int len = s.length();
	if (len == 0)
	    return result;
	int i = s.indexOf(separator);
	if (i < 0) {
	    result.add(s);
	    return result;
	}
	int skip = separator.length();
	int start = 0;
	while (i >= 0) {
	    result.add(s.substring(start, i));
	    start = i + skip;
	    if (start == len) break; // shortcut
	    i = s.indexOf(separator, start);
	}
	result.add(s.substring(start));
	return result;
    }

}
