/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug 18 23:36:05 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

/**
 * A utility class that makes it easier to define a DirectedGraph.
 * Only the {@link #getSuccessors(Object)} method must be defined
 * by a subclass; however, some other methods will throw an
 * UnsupportedOperationException if the subclass does not redefine
 * them.  Method {@link #isBefore(Object a, Object b)} returns
 * <code>getSuccessors(a).contains(b)</code>.
 */
public abstract class AbstractDirectedGraph implements DirectedGraph {

    public AbstractDirectedGraph() {
    }

    public Collection getAllNodes() {
	throw new UnsupportedOperationException("getAllNodes");
    }

    public Collection getRoots() {
	throw new UnsupportedOperationException("getRoots");
    }

    public abstract Collection getSuccessors(Object node);

    public boolean isBefore(Object a, Object b) {
	return getSuccessors(a).contains(b);
    }

}
