/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Jan 26 19:02:53 2005 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.util.*;

import ix.icore.plan.Plan;
import ix.icore.domain.Domain;

import ix.iplan.AutoTester;
import ix.iplan.PlanTest;
import ix.iplan.PlanCheckingSimulator;

import ix.test.BlockStacker;

import ix.util.*;

/**
 * Describes a block-stacking plan test.
 */
public class BlockStackingTest extends PlanTest {

    String problem;

    public BlockStackingTest() {
        super();
    }

    public String getProblem() {
	return problem;
    }

    public void setProblem(String problem) {
	this.problem = problem;
    }

    public void setTask(String task) {
	throw new UnsupportedOperationException();
    }

    public void setInitialPlan(String initialPlan) {
	throw new UnsupportedOperationException();
    }

    public String testDescription() {
	return "Domain " + getDomain() +
	    ", Problem " + getProblem();
    }

    public String taskDescription() { // needed by savePlan
	return getProblem();
    }

    public AutoTester.TestRunner makeTestRunner(AutoTester auto) {
	return new BlockTestRunner(this, auto);
    }

    static class BlockTestRunner extends AutoTester.TestRunner {

	AutoTester auto;
	Stacker stacker;
	BlockStackingTest test;

	BlockTestRunner(BlockStackingTest test, AutoTester auto) {
	    auto.super(test);
	    this.auto = auto;
	    this.test = test;
	    this.stacker = new Stacker(test.getProblem());
	}

	protected Domain readDomain() {
	    Domain domain = stacker.problemDomain();
	    domain.takeFrom(super.readDomain());
	    return domain;
	}

	protected Plan initialPlan() {
	    return stacker.initialPlan();
	}

	protected void runSimulation(PlanCheckingSimulator sim) {
	    super.runSimulation(sim);
	    List fails = stacker.failedGoalPatterns(sim.getWorldStateMap());
	    if (!fails.isEmpty())
		auto.testFailure(test, "False patterns " + fails);
	    else
		auto.traceln("World state is correct");
	}

    }

    static class Stacker extends BlockStacker {

	Stacker(String problem) {
	    super(problem);
	}

	protected void setup(String problem) {
	    // Parse the problem description.
	    parseTowers(problem);
	    // But don't create a planner.
	}

	Domain problemDomain() {
	    return problemDomain(initialTowers, finalTowers);
	}

	Plan initialPlan() {
	    return initialPlan(initialTowers, finalTowers);
	}

	List failedGoalPatterns(Map state) {
	    return incorrectTowerPatterns(state, finalTowers);
	}

    }

}
