/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Oct 17 17:22:09 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.util.*;
import ix.util.xml.*;

public class XMLSendTest {

    public static void main(String[] argv) {

	Parameters.processCommandLineArguments(argv);

	IPC.XMLObjectStreamCommunicationStrategy strategy = new TestStrategy();

	Parameters.checkParameterUse();

	for (;;) {
	    String toName = Util.askLine("Send to: ");
	    String text = Util.askLine("Type some XML:");
	    strategy.sendObject(toName, text);
	}

    }

    static class TestStrategy extends IPC.SimpleIXXMLCommunicationStrategy {

	TestStrategy() {
	    super();
	    setupNameServerAddress();
	}

	public Object preEncode(Object contents) {
	    return contents;
	}

    }

}
