/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Feb 18 00:20:44 2006 by Jeff Dalton
 * Copyright: (c) 2002 - 2006, AIAI, University of Edinburgh
 */

package ix.test;

import java.io.*;
import java.util.*;

import ix.util.*;
import ix.util.xml.*;
import ix.util.reflect.ClassSyntax;

public class XMLFileTest extends SerializationTest {

    // N.B. It's important that this include the implClass attributes
    // in the XML so that we can use it to see what sort of object
    // we've actually got when testing a translator that omits
    // the impl class information.
    XMLTranslator xmlt =
	new XMLTranslator(config.defaultClassSyntax());

    /**
     * Simple main program used for testing.
     */
    public static void main(String[] argv) {
	new XMLFileTest().do_main(argv);
    }

    void test(XMLTranslator xmlt, Object obj) {
	String xml = xmlt.objectToXMLString(obj);
	Object back = xmlt.objectFromXML(xml);
	Debug.expect(flexibleEquality.equal(obj, back),
		     "Not structurally equal");
    }

}
