/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 23 13:56:44 2005 by Jeff Dalton
 * Copyright: (c) 2004, 2005, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.ip2.Ip2XMLConfig;
import ix.util.*;
import ix.util.xml.*;

public class TranslateFile {

    public static void main(String[] argv) {
	Debug.off();
	if (argv.length < 2) {
	    System.err.println("Usage: translate-file filename ... type");
	    System.exit(1);
	}
	String type = argv[argv.length - 1];
	for (int i = 0; i < argv.length - 1; i++) {
	    translateFile(argv[i], type);
	}
    }

    static void translateFile(String fileName, String toType) {
	System.out.println("Translating " + fileName);
	FileSyntaxManager fsm = new Ip2XMLConfig().makeFileSyntaxManager();
	String outName = fsm.getExceptType(fileName) + "." + toType;
	FileSyntax outSyntax = fsm.getSyntax(outName);
	Object obj = fsm.readObject(Object.class, fileName);
	if (fsm.canWrite(outSyntax, obj.getClass()))
	    fsm.writeObject(obj, outName);
	else
	    System.err.println
		("Can't translate a " + XML.nameForClass(obj.getClass()) +
		 " as a file of type " + Strings.quote(toType));
    }

}

