/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jan 17 15:54:30 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.IXAgent;
import ix.util.*;

public class ThreadConditionTest {

    static ThreadCondition cond = new ThreadCondition("example cond");

    public static void main(String[] argv) {

	Debug.noteln("Condition:", cond);

	IXAgent agent = new SimpleIXAgent(); // /\/ Makes ToolFrame happy

	TextAreaFrame frame
	    = new TextAreaFrame("Example",
				new String[] {"Done"});

	frame.addListener(new TextAreaFrame.TListener() {
	    public void buttonPressed(String action) {
		if (action.equals("Done"))
		    cond.setTrue();
	    }
	});

	cond.waitUntilTrue(3000);
	if (cond.isTrue())
	    Debug.noteln("Seems to be finished");
	else
	    Debug.noteln("Timeout");
	System.exit(0);

    }

}
