/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed May 31 02:00:21 2006 by Jeff Dalton
 * Copyright: (c) 2004, 2005, 2006, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.iplan.*;
import ix.icore.*;
import ix.icore.plan.*;
import ix.icore.plan.build.*;
import ix.icore.domain.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * Used for running planning problems.
 */
public class PlanningTest {

    Planner planner;

    Domain domain;

    public PlanningTest() {
	setup();
    }

    public static void main(String[] argv) {
	Parameters.processCommandLineArguments(argv);
	PlanningTest ptest = new PlanningTest();
	ptest.findPlan();
	while (true) {
	    ptest.checkPlan();
	    if (Util.askLine("Replan?").trim().startsWith("y"))
		ptest.replan();
	    else
		System.exit(0);
	}
    }

    protected void setup() {
	String domainName = Parameters.getParameter("domain");
	String plan = Parameters.getParameter("plan");
	String task = Parameters.getParameter("task");
	planner = IPlan.makeDefaultPlanner();
	if (domain != null) {
	    domain = (Domain)XML.readObject(Domain.class, domainName);
	    planner.setDomain(domain);
	}
	if (plan != null)
	    planner.loadPlan((Plan)XML.readObject(Plan.class, plan));
	if (task != null)
	    planner.loadPlan(initialPlan(task));
    }

    /*
    Planner makeTestPlanner() {
	// Make the planner the main I-X agent, but
	// don't give it any command-line arguments.
	// It will still see any parameters we got from the command-line.
	// For instance, it will see "domain" and "plan".
	// (It loads plan and domain only because it's the main agent.)
	Slip slip = new Slip(true);
	slip.mainStartup(new String[]{});
	return slip;
    }
    */

    Plan initialPlan(String task) {
	PlanBuilder builder = new SimplePlanBuilder();
	LList taskPattern = Lisp.elementsFromString(task);
	builder.addActivity(new Activity(taskPattern));
	return builder.getPlan();
    }

    public void findPlan() {
	planner.plan();
    }

    public void replan() {
	planner.replan();
    }

    public void checkPlan() {

	// Simulate plan execution.
	PlanCheckingSimulator sim =
	    new PlanCheckingSimulator(planner.getPlan(), domain);
	sim.run();

	// Print a report that describes any problems found.
	sim.report();

	// Describe the changes in the world state
	sim.describeChangedWorldState();

    }

}
